/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.util.HashMap;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.Resource;
import org.codehaus.cargo.container.jboss.JBoss73xStandaloneLocalConfiguration;
import org.codehaus.cargo.container.jboss.JBoss7xInstalledLocalContainer;
import org.codehaus.cargo.container.jboss.internal.JBoss75xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultXmlFileBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JBoss75xStandaloneLocalConfiguration
extends JBoss73xStandaloneLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new JBoss75xStandaloneLocalConfigurationCapability();

    public JBoss75xStandaloneLocalConfiguration(String dir) {
        super(dir);
    }

    @Override
    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    @Override
    protected void doConfigure(LocalContainer c) throws Exception {
        super.doConfigure(c);
        this.addResources((JBoss7xInstalledLocalContainer)c);
    }

    protected void addResources(JBoss7xInstalledLocalContainer container) {
        String version = container.getVersion("7.5.7.Final");
        this.getLogger().debug("Parsing micro version for version: " + version, this.getClass().getName());
        String microVersion = version.substring(version.indexOf(".", 2) + 1, version.indexOf(".", 4));
        int microVersionValue = Integer.parseInt(microVersion);
        String configurationXmlFile = "configuration/" + this.getPropertyValue("cargo.jboss.configuration") + ".xml";
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("mail", "urn:jboss:domain:mail:1.2");
        if (microVersionValue >= 7) {
            ns.put("domain", "urn:jboss:domain:1.8");
        } else {
            ns.put("domain", "urn:jboss:domain:1.7");
        }
        String configurationXmlFilePath = this.getFileHandler().append(this.getHome(), configurationXmlFile);
        for (Resource resource : this.getResources()) {
            if ("javax.mail.Session".equals(resource.getType())) {
                String host = resource.getParameter("mail.smtp.host") != null ? resource.getParameter("mail.smtp.host") : "localhost";
                String port = resource.getParameter("mail.smtp.port") != null ? resource.getParameter("mail.smtp.port") : "25";
                DefaultXmlFileBuilder manager = new DefaultXmlFileBuilder(this.getFileHandler(), true);
                manager.setFile(configurationXmlFilePath);
                Document document = manager.loadFile();
                manager.setNamespaces(ns);
                String jndiName = resource.getName();
                if (!jndiName.startsWith("java:/")) {
                    jndiName = "java:/" + jndiName;
                    this.getLogger().warn("JBoss 7 requires resource JNDI names to start with java:/, hence changing the given JNDI name to: " + jndiName, this.getClass().getName());
                }
                Element mailSession = document.createElement("mail-session");
                mailSession.setAttribute("jndi-name", jndiName);
                mailSession.setAttribute("name", resource.getId());
                if (resource.getParameter("mail.smtp.from") != null) {
                    mailSession.setAttribute("from", resource.getParameter("mail.smtp.from"));
                }
                Element smtpServer = mailSession.getOwnerDocument().createElement("smtp-server");
                mailSession.appendChild(smtpServer);
                smtpServer.setAttribute("outbound-socket-binding-ref", resource.getId());
                manager.insertElementUnderXPath(mailSession, "//domain:profile/mail:subsystem");
                Element socketBinding = document.createElement("outbound-socket-binding");
                socketBinding.setAttribute("name", resource.getId());
                Element remoteDestination = socketBinding.getOwnerDocument().createElement("remote-destination");
                socketBinding.appendChild(remoteDestination);
                remoteDestination.setAttribute("host", host);
                remoteDestination.setAttribute("port", port);
                manager.insertElementUnderXPath(socketBinding, "//domain:socket-binding-group");
                manager.writeFile();
                continue;
            }
            throw new CargoException("Resource type " + resource.getType() + " isn't supported.");
        }
    }
}

