/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.internal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Vector;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

public final class ResourceUtils
extends LoggedObject {
    private static FileHandler defaultFileHandler = new DefaultFileHandler();
    private static ClassLoader resourceLoader = ResourceUtils.class.getClassLoader();

    public static ClassLoader getResourceLoader() {
        return resourceLoader;
    }

    public static void setResourceLoader(ClassLoader resourceLoader) {
        ResourceUtils.resourceLoader = resourceLoader;
    }

    public void copyResource(String resourceName, File destFile) throws IOException {
        this.copyResource(resourceName, destFile.getPath(), defaultFileHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(String resourceName, String destFile, FileHandler handler) throws IOException {
        InputStream in = resourceLoader.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IOException("Resource [" + resourceName + "] not found in resource loader " + resourceLoader);
        }
        OutputStream out = null;
        try {
            int numBytes;
            out = handler.getOutputStream(destFile);
            byte[] buf = new byte[4096];
            while ((numBytes = in.read(buf)) > 0) {
                out.write(buf, 0, numBytes);
            }
        }
        finally {
            in.close();
            if (out != null) {
                out.close();
            }
        }
    }

    public void copyResource(String resourceName, File destFile, FilterChain filterChain, String encoding) throws IOException {
        this.copyResource(resourceName, destFile.getPath(), defaultFileHandler, filterChain, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResource(String resourceName, String destFile, FileHandler handler, FilterChain filterChain, String encoding) throws IOException {
        InputStream resource = resourceLoader.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new IOException("Resource [" + resourceName + "] not found in resource loader " + resourceLoader);
        }
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            String line;
            ChainReaderHelper helper = new ChainReaderHelper();
            helper.setBufferSize(8192);
            helper.setPrimaryReader(new BufferedReader(this.createReader(resource, encoding)));
            Vector<FilterChain> filterChains = new Vector<FilterChain>();
            filterChains.add(filterChain);
            helper.setFilterChains(filterChains);
            in = new BufferedReader(helper.getAssembledReader());
            out = new BufferedWriter(new OutputStreamWriter(handler.getOutputStream(destFile)));
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) {
                    out.newLine();
                    continue;
                }
                out.write(line);
                out.newLine();
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private InputStreamReader createReader(InputStream is, String encoding) throws UnsupportedEncodingException {
        InputStreamReader r = encoding != null ? new InputStreamReader(is, encoding) : new InputStreamReader(is);
        return r;
    }

    public File getResourceLocation(Class where, String resourceName) {
        URL url = where.getResource(resourceName);
        if (url == null) {
            throw new CargoException("Cannot find resource [" + resourceName + "]");
        }
        File file = null;
        String urlString = url.toString();
        if (urlString.startsWith("jar:file:")) {
            int pling = urlString.indexOf("!");
            String jar = urlString.substring(9, pling);
            file = new File(URLDecoder.decode(jar));
        } else if (urlString.startsWith("file:")) {
            int tail = urlString.indexOf(resourceName);
            String dir = urlString.substring(5, tail);
            file = new File(URLDecoder.decode(dir));
        }
        this.getLogger().debug("Location for [" + resourceName + "] is [" + file + "]", this.getClass().getName());
        return file;
    }

    public String readResource(String resourceName, FilterChain filterChain, String encoding) {
        String newLine = System.getProperty("line.separator");
        InputStream resource = resourceLoader.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new CargoException("Resource [" + resourceName + "] not found in resource loader " + resourceLoader);
        }
        BufferedReader in = null;
        StringBuffer out = null;
        try {
            String line;
            ChainReaderHelper helper = new ChainReaderHelper();
            helper.setBufferSize(8192);
            helper.setPrimaryReader(new BufferedReader(this.createReader(resource, encoding)));
            Vector<FilterChain> filterChains = new Vector<FilterChain>();
            filterChains.add(filterChain);
            helper.setFilterChains(filterChains);
            in = new BufferedReader(helper.getAssembledReader());
            out = new StringBuffer();
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) {
                    out.append(newLine);
                    continue;
                }
                if (out.length() > 0) {
                    out.append(newLine);
                }
                out.append(line);
            }
        }
        catch (IOException e) {
            throw new CargoException("Error while reading resource [" + resourceName + "] ", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.getLogger().warn("Failed to close input stream for [" + resourceName + "]", this.getClass().getName());
                }
            }
        }
        return out.toString();
    }
}

