/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public abstract class AbstractXMLSerializer
implements Traceable {
    private final Transformer transformer;

    protected AbstractXMLSerializer() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            this.transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private DOMImplementationRegistry createDOMImplRegistry() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("DOMImplementationRegistry", this, "createDOMImplRegistry()");
        try {
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            return dOMImplementationRegistry;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | DOMException ex) {
            tracer.logException(LogLevel.ERROR, ex, this.getClass(), "createDOMImplRegistry()");
            throw new RuntimeException("Cannot create DOMImplRegistry.");
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Node node, OutputStream outputStream) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, "serialize(Node node, OutputStream outputStream)");
        try {
            try {
                this.transformer.transform(new DOMSource(node), new StreamResult(outputStream));
            }
            catch (TransformerException ex) {
                tracer.logException(LogLevel.ERROR, ex, this.getClass(), "void serialize(Node node, OutputStream outputStream)");
                throw new RuntimeException(ex);
            }
        }
        finally {
            tracer.wayout();
        }
    }
}

