/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package de.christofreichardt.jaxws.securitypriceservice;

/**
 *
 * @author Christof Reichardt
 */
public class MySecurityPrice {
  final private AbstractSecurityPrice securityPrice;

  public MySecurityPrice(AbstractSecurityPrice securityPrice) {
    this.securityPrice = securityPrice;
  }

  @Override
  public String toString() {
    StringBuilder stringBuilder = new StringBuilder();
    if (this.securityPrice instanceof IndexPrice) {
      IndexPrice indexPrice = (IndexPrice) this.securityPrice;
      stringBuilder.append("IndexPrice[");
      if (indexPrice.getSecurity() != null) {
        stringBuilder.append("Security[");
        stringBuilder.append("Name=");
        stringBuilder.append(indexPrice.getSecurity().getName());
        stringBuilder.append(", ");
        stringBuilder.append("WKN=");
        stringBuilder.append(indexPrice.getSecurity().getWKN());
        stringBuilder.append(", ");
        stringBuilder.append("ISIN=");
        stringBuilder.append(indexPrice.getSecurity().getISIN());
        stringBuilder.append("]");
      }
      stringBuilder.append("Ask=");
      stringBuilder.append(indexPrice.getAsk());
      stringBuilder.append(", ");
      stringBuilder.append("Bid=");
      stringBuilder.append(indexPrice.getBid());
      stringBuilder.append(", ");
      stringBuilder.append("Issuer=");
      stringBuilder.append(indexPrice.getIssuer());
      stringBuilder.append("]");
    }
    else if (this.securityPrice instanceof OptionPrice) {
      OptionPrice optionPrice = (OptionPrice) this.securityPrice;
      stringBuilder.append("OptionPrice[");
      if (optionPrice.getSecurity() != null) {
        stringBuilder.append("Security[");
        stringBuilder.append("Name=");
        stringBuilder.append(optionPrice.getSecurity().getName());
        stringBuilder.append(", ");
        stringBuilder.append("WKN=");
        stringBuilder.append(optionPrice.getSecurity().getWKN());
        stringBuilder.append(", ");
        stringBuilder.append("ISIN=");
        stringBuilder.append(optionPrice.getSecurity().getISIN());
        stringBuilder.append("]");
      }
      stringBuilder.append("Ask=");
      stringBuilder.append(optionPrice.getAsk());
      stringBuilder.append(", ");
      stringBuilder.append("Bid=");
      stringBuilder.append(optionPrice.getBid());
      stringBuilder.append(", ");
      stringBuilder.append("Exercise=");
      stringBuilder.append(optionPrice.getExercise());
      stringBuilder.append(", ");
      stringBuilder.append("ExpirationDate=");
      stringBuilder.append(optionPrice.getExpirationDate());
      stringBuilder.append(", ");
      stringBuilder.append("StrikePrice=");
      stringBuilder.append(optionPrice.getStrikePrice());
      stringBuilder.append("]");
    }
    else if (this.securityPrice instanceof SharePrice) {
      SharePrice sharePrice = (SharePrice) this.securityPrice;
      stringBuilder.append("SharePrice[");
      if (sharePrice.getSecurity() != null) {
        stringBuilder.append("Security[");
        stringBuilder.append("Name=");
        stringBuilder.append(sharePrice.getSecurity().getName());
        stringBuilder.append(", ");
        stringBuilder.append("WKN=");
        stringBuilder.append(sharePrice.getSecurity().getWKN());
        stringBuilder.append(", ");
        stringBuilder.append("ISIN=");
        stringBuilder.append(sharePrice.getSecurity().getISIN());
        stringBuilder.append("]");
      }
      stringBuilder.append("Ask=");
      stringBuilder.append(sharePrice.getAsk());
      stringBuilder.append(", ");
      stringBuilder.append("Bid=");
      stringBuilder.append(sharePrice.getBid());
      stringBuilder.append(", ");
      stringBuilder.append("Rate=");
      stringBuilder.append(sharePrice.getRate());
      stringBuilder.append("]");
    }
    else if (this.securityPrice instanceof UnknownPrice) {
      UnknownPrice unknownPrice = (UnknownPrice) this.securityPrice;
      stringBuilder.append("UnknownPrice[");
      if (unknownPrice.getSecurity() != null) {
        stringBuilder.append("Security[");
        stringBuilder.append("Name=");
        stringBuilder.append(unknownPrice.getSecurity().getName());
        stringBuilder.append(", ");
        stringBuilder.append("WKN=");
        stringBuilder.append(unknownPrice.getSecurity().getWKN());
        stringBuilder.append(", ");
        stringBuilder.append("ISIN=");
        stringBuilder.append(unknownPrice.getSecurity().getISIN());
        stringBuilder.append("]");
      }
      stringBuilder.append("]");
    }
    
    return stringBuilder.toString();
  }
}
