/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.junit;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class TraceTestListener
extends RunListener
implements Traceable {
    public void testFailure(Failure failure) throws Exception {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "testFailure(Failure failure)");
        try {
            super.testFailure(failure);
            tracer.out().printfIndentln("%s[failure.getException() = %s]", new Object[]{failure.getDescription().getDisplayName(), failure.getException()});
        }
        finally {
            tracer.wayout();
        }
    }

    public void testFinished(Description description) throws Exception {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "testFinished(Description description)");
        try {
            tracer.out().printfIndentln("description.getDisplayName() = %s", new Object[]{description.getDisplayName()});
            this.traceMemory();
            super.testFinished(description);
        }
        finally {
            tracer.wayout();
        }
    }

    public void testRunFinished(Result result) throws Exception {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "testRunFinished(Result result)");
        try {
            super.testRunFinished(result);
        }
        finally {
            tracer.wayout();
        }
    }

    public void testRunStarted(Description description) throws Exception {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "testRunStarted(Description description)");
        try {
            this.traceDescription(description);
            super.testRunStarted(description);
        }
        finally {
            tracer.wayout();
        }
    }

    public void testStarted(Description description) throws Exception {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "testStarted(Description description)");
        try {
            tracer.logMessage(LogLevel.INFO, "'" + description.getDisplayName() + "' started ...", ((Object)((Object)this)).getClass(), "testStarted(Description description)");
            System.runFinalization();
            System.gc();
            this.traceMemory();
            super.testStarted(description);
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDescription(Description description) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "traceDescription(Description description)");
        try {
            tracer.out().printfIndentln("description.getDisplayName() = %s", new Object[]{description.getDisplayName()});
            if (description.isSuite()) {
                tracer.out().printfIndentln("description.testCount() = %d", new Object[]{description.testCount()});
                for (Description child : description.getChildren()) {
                    this.traceDescription(child);
                }
            }
        }
        finally {
            tracer.wayout();
        }
    }

    private void traceMemory() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "traceMemory()");
        try {
            tracer.out().printfIndentln("Free: %d KB", new Object[]{Runtime.getRuntime().freeMemory() / 1024L});
            tracer.out().printfIndentln("Total: %d KB", new Object[]{Runtime.getRuntime().totalMemory() / 1024L});
            tracer.out().printfIndentln("Max: %d KB", new Object[]{Runtime.getRuntime().maxMemory() / 1024L});
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }
}

