/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

public final class Base64 {
    private static final char[] ENCODE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char PAD_CHAR = '=';

    private Base64() {
    }

    public static byte[] encodeBase64(byte[] bytes) {
        return Base64.encode(bytes);
    }

    public static String encode(String string) {
        return new String(Base64.encode(string.getBytes()));
    }

    public static byte[] encode(byte[] bytes) {
        return Base64.encodeToString(bytes).getBytes();
    }

    public static String encodeToString(byte[] bytes) {
        int length = bytes.length;
        StringBuilder buffer = new StringBuilder(length * 3);
        for (int i = 0; i < length; i += 3) {
            int p5;
            int p4;
            int p3;
            int p2;
            int p0 = bytes[i] & 0xFC;
            p0 >>= 2;
            int p1 = bytes[i] & 3;
            p1 <<= 4;
            if (i + 1 < length) {
                p2 = bytes[i + 1] & 0xF0;
                p2 >>= 4;
                p3 = bytes[i + 1] & 0xF;
                p3 <<= 2;
            } else {
                p2 = 0;
                p3 = 0;
            }
            if (i + 2 < length) {
                p4 = bytes[i + 2] & 0xC0;
                p4 >>= 6;
                p5 = bytes[i + 2] & 0x3F;
            } else {
                p4 = 0;
                p5 = 0;
            }
            if (i + 2 < length) {
                buffer.append(ENCODE[p0]);
                buffer.append(ENCODE[p1 | p2]);
                buffer.append(ENCODE[p3 | p4]);
                buffer.append(ENCODE[p5]);
                continue;
            }
            if (i + 1 < length) {
                buffer.append(ENCODE[p0]);
                buffer.append(ENCODE[p1 | p2]);
                buffer.append(ENCODE[p3]);
                buffer.append('=');
                continue;
            }
            buffer.append(ENCODE[p0]);
            buffer.append(ENCODE[p1 | p2]);
            buffer.append('=');
            buffer.append('=');
        }
        return buffer.toString();
    }
}

