/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.packager;

import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.packager.Packager;
import org.codehaus.cargo.container.packager.PackagerType;
import org.codehaus.cargo.generic.AbstractFactoryRegistry;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.internal.util.SimpleContainerIdentity;
import org.codehaus.cargo.generic.packager.PackagerFactory;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.generic.spi.AbstractIntrospectionGenericHintFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPackagerFactory
extends AbstractIntrospectionGenericHintFactory<Packager>
implements PackagerFactory {
    public DefaultPackagerFactory() {
        this(null);
    }

    public DefaultPackagerFactory(ClassLoader classLoader) {
        AbstractFactoryRegistry.register(classLoader, this);
    }

    @Override
    public void registerPackager(String containerId, PackagerType packagerType, Class<? extends Packager> packagerClass) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), packagerType.getType()), packagerClass);
    }

    public void registerPackager(String containerId, PackagerType packagerType, String packagerClassName) {
        this.registerImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), packagerType.getType()), packagerClassName);
    }

    @Override
    public boolean isPackagerRegistered(String containerId, PackagerType packagerType) {
        return this.hasMapping(new RegistrationKey(new SimpleContainerIdentity(containerId), packagerType.getType()));
    }

    @Override
    public Packager createPackager(String containerId, PackagerType packagerType, String outputLocation) {
        PackagerFactoryParameters parameters = new PackagerFactoryParameters();
        parameters.outputLocation = outputLocation;
        return (Packager)this.createImplementation(new RegistrationKey(new SimpleContainerIdentity(containerId), packagerType.getType()), parameters, "packager");
    }

    @Override
    protected Constructor<? extends Packager> getConstructor(Class<? extends Packager> deployerClass, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        PackagerType type = PackagerType.toType(hint);
        if (type != PackagerType.DIRECTORY) {
            throw new ContainerException("Unknown packager type [" + type.getType() + "]");
        }
        Constructor<? extends Packager> constructor = deployerClass.getConstructor(String.class);
        return constructor;
    }

    @Override
    protected Packager createInstance(Constructor<? extends Packager> constructor, String hint, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        String outputLocation = ((PackagerFactoryParameters)parameters).outputLocation;
        return constructor.newInstance(outputLocation);
    }

    private static class PackagerFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public String outputLocation;

        private PackagerFactoryParameters() {
        }
    }
}

