/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.deployer;

import java.io.File;
import java.lang.reflect.Constructor;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.RuntimeConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.EAR;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractRemoteDeployer;
import org.codehaus.cargo.util.CargoException;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;

public abstract class AbstractJsr88Deployer
extends AbstractRemoteDeployer {
    private final RuntimeConfiguration configuration;
    private final FileHandler fileHandler;

    public AbstractJsr88Deployer(RemoteContainer container) {
        super(container);
        this.configuration = container.getConfiguration();
        this.fileHandler = new DefaultFileHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(Deployable deployable) {
        File deployableFile;
        File tempDirectory;
        if (deployable.getType() == DeployableType.WAR) {
            WAR war = (WAR)deployable;
            String localFileName = war.getContext().length() == 0 ? "rootContext.war" : war.getContext() + ".war";
            tempDirectory = new File(this.fileHandler.createUniqueTmpDirectory());
            deployableFile = new File(tempDirectory, localFileName);
            this.fileHandler.copyFile(deployable.getFile(), deployableFile.getAbsolutePath());
            deployableFile.deleteOnExit();
        } else if (deployable.getType() == DeployableType.EAR) {
            EAR ear = (EAR)deployable;
            String localFileName = ear.getName() + ".ear";
            tempDirectory = new File(this.fileHandler.createUniqueTmpDirectory());
            deployableFile = new File(tempDirectory, localFileName);
            this.fileHandler.copyFile(deployable.getFile(), deployableFile.getAbsolutePath());
            deployableFile.deleteOnExit();
        } else {
            deployableFile = new File(deployable.getFile());
            tempDirectory = null;
        }
        try {
            DeploymentManager deploymentManager = this.getDeploymentManager();
            ProgressObject progressObject = deploymentManager.distribute(deploymentManager.getTargets(), deployableFile, null);
            this.waitForProgressObject(progressObject);
            progressObject = deploymentManager.start(progressObject.getResultTargetModuleIDs());
            this.waitForProgressObject(progressObject);
        }
        finally {
            if (tempDirectory != null) {
                if (!deployableFile.delete()) {
                    this.getLogger().warn("Cannot delete the temporary file: " + deployableFile, this.getClass().getName());
                }
                if (!tempDirectory.delete()) {
                    this.getLogger().warn("Cannot delete the temporary directory: " + tempDirectory, this.getClass().getName());
                }
            }
        }
    }

    public void undeploy(Deployable deployable) {
        TargetModuleID[] targetModules;
        DeploymentManager deploymentManager = this.getDeploymentManager();
        try {
            targetModules = this.findTargetModule(deploymentManager, deployable);
        }
        catch (TargetException e) {
            throw new CargoException("Cannot communicate with the server", e);
        }
        ProgressObject progressObject = deploymentManager.stop(targetModules);
        this.waitForProgressObject(progressObject);
        progressObject = deploymentManager.undeploy(targetModules);
        this.waitForProgressObject(progressObject);
    }

    public void redeploy(Deployable deployable) {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        TargetModuleID[] targetModules = null;
        try {
            targetModules = this.findTargetModule(deploymentManager, deployable);
        }
        catch (TargetException e) {
            throw new CargoException("Cannot communicate with the server", e);
        }
        catch (CargoException e) {
            // empty catch block
        }
        if (targetModules != null) {
            ProgressObject progressObject = deploymentManager.stop(targetModules);
            this.waitForProgressObject(progressObject);
            progressObject = deploymentManager.undeploy(targetModules);
            this.waitForProgressObject(progressObject);
        }
        this.deploy(deployable);
    }

    public void start(Deployable deployable) {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        TargetModuleID[] targetModules = null;
        try {
            targetModules = this.findTargetModule(deploymentManager, deployable);
        }
        catch (TargetException e) {
            throw new CargoException("Cannot communicate with the server", e);
        }
        ProgressObject progressObject = deploymentManager.start(targetModules);
        this.waitForProgressObject(progressObject);
    }

    public void stop(Deployable deployable) {
        DeploymentManager deploymentManager = this.getDeploymentManager();
        TargetModuleID[] targetModules = null;
        try {
            targetModules = this.findTargetModule(deploymentManager, deployable);
        }
        catch (TargetException e) {
            throw new CargoException("Cannot communicate with the server", e);
        }
        ProgressObject progressObject = deploymentManager.stop(targetModules);
        this.waitForProgressObject(progressObject);
    }

    private void waitForProgressObject(ProgressObject progressObject) throws CargoException {
        long timeout = System.currentTimeMillis() + this.getTimeout();
        while (System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new CargoException("Thread.sleep has failed", e);
            }
            DeploymentStatus status = progressObject.getDeploymentStatus();
            if (status.isCompleted()) {
                return;
            }
            if (!status.isFailed()) continue;
            throw new CargoException("Deployment has failed: " + status.getMessage());
        }
        throw new CargoException("Deployment has timed out after " + this.getTimeout() + " milliseconds");
    }

    private long getTimeout() {
        return 120000L;
    }

    private DeploymentManager getDeploymentManager() throws CargoException {
        DeploymentFactoryManager dfm = DeploymentFactoryManager.getInstance();
        String deploymentFactoryClassName = this.getDeploymentFactoryClassName();
        try {
            Class<?> deploymentFactoryClass = null;
            ClassLoader tcccl = Thread.currentThread().getContextClassLoader();
            if (tcccl != null) {
                try {
                    deploymentFactoryClass = tcccl.loadClass(deploymentFactoryClassName);
                }
                catch (ClassNotFoundException e) {
                    deploymentFactoryClass = null;
                }
            }
            if (deploymentFactoryClass == null) {
                deploymentFactoryClass = this.getClass().getClassLoader().loadClass(deploymentFactoryClassName);
            }
            Constructor<?> deploymentFactoryConstructor = deploymentFactoryClass.getConstructor(new Class[0]);
            DeploymentFactory deploymentFactoryInstance = (DeploymentFactory)deploymentFactoryConstructor.newInstance(new Object[0]);
            dfm.registerDeploymentFactory(deploymentFactoryInstance);
        }
        catch (ClassNotFoundException e) {
            throw new CargoException("Cannot locate the JSR-88 deployer class " + deploymentFactoryClassName + "\n" + "Make sure the target server's librarires are in CARGO's classpath.\n" + "More information on: http://cargo.codehaus.org/JSR88", e);
        }
        catch (Throwable t) {
            throw new CargoException("Cannot create a JSR-88 deployer: " + t.getMessage(), t);
        }
        try {
            return this.getDeploymentManager(dfm);
        }
        catch (DeploymentManagerCreationException e) {
            throw new CargoException("Cannot create the DeploymentManager", e);
        }
    }

    protected abstract String getDeploymentFactoryClassName();

    protected abstract DeploymentManager getDeploymentManager(DeploymentFactoryManager var1) throws DeploymentManagerCreationException;

    private TargetModuleID[] findTargetModule(DeploymentManager deploymentManager, Deployable deployable) throws CargoException, TargetException {
        ModuleType moduleType;
        String moduleName;
        if (deployable.getType() == DeployableType.WAR) {
            WAR war = (WAR)deployable;
            moduleName = war.getContext().length() == 0 ? "rootContext" : war.getContext();
        } else if (deployable.getType() == DeployableType.EAR) {
            EAR ear = (EAR)deployable;
            moduleName = ear.getName();
        } else {
            File moduleFile = new File(deployable.getFile());
            moduleName = moduleFile.getName();
            int extensionSeparator = moduleName.lastIndexOf(46);
            if (extensionSeparator != -1) {
                moduleName = moduleName.substring(0, extensionSeparator);
            }
        }
        if (DeployableType.EAR.equals(deployable.getType())) {
            moduleType = ModuleType.EAR;
        } else if (DeployableType.EJB.equals(deployable.getType())) {
            moduleType = ModuleType.EJB;
        } else if (DeployableType.RAR.equals(deployable.getType())) {
            moduleType = ModuleType.RAR;
        } else if (DeployableType.WAR.equals(deployable.getType())) {
            moduleType = ModuleType.WAR;
        } else {
            throw new IllegalArgumentException("CARGO deployable type " + deployable.getType() + " has no JSR-88 match and cannot be remotely deployed.");
        }
        TargetModuleID targetModule = null;
        TargetModuleID[] modules = deploymentManager.getRunningModules(moduleType, deploymentManager.getTargets());
        StringBuilder sb = new StringBuilder();
        sb.append("Cannot find the module \"");
        sb.append(moduleName);
        sb.append("\". Available modules:");
        for (TargetModuleID module : modules) {
            String moduleId = module.getModuleID();
            if (moduleName.equals(moduleId)) {
                targetModule = module;
                break;
            }
            sb.append("\n\t- ");
            sb.append(moduleId);
        }
        if (targetModule == null) {
            throw new CargoException(sb.toString());
        }
        TargetModuleID[] targetModules = new TargetModuleID[]{targetModule};
        return targetModules;
    }

    protected RuntimeConfiguration getRuntimeConfiguration() {
        return this.configuration;
    }
}

