/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jboss.JBossInstalledLocalDeployer;
import org.codehaus.cargo.container.jboss.internal.JBossExistingLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;

public class JBossExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new JBossExistingLocalConfigurationCapability();

    public JBossExistingLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1099");
        this.setProperty("cargo.jboss.configuration", "default");
        this.setProperty("cargo.jboss.naming.port", "1098");
        this.setProperty("cargo.jboss.classloading.webservice.port", "8083");
        this.setProperty("cargo.jboss.jrmp.port", "1090");
        this.setProperty("cargo.jboss.jrmp.invoker.port", "4444");
        this.setProperty("cargo.jboss.invoker.pool.port", "4445");
        this.setProperty("cargo.jboss.remoting.transport.port", "4446");
        this.setProperty("cargo.jboss.ejb3.remoting.port", "3873");
        this.setProperty("cargo.jboss.transaction.recoveryManager.port", "4712");
        this.setProperty("cargo.jboss.transaction.statusManager.port", "4713");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        InstalledLocalContainer jbossContainer = (InstalledLocalContainer)container;
        File deployDir = new File(this.getHome(), "deploy");
        if (!deployDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + deployDir.getPath() + "] directory does not exist");
        }
        JBossInstalledLocalDeployer deployer = new JBossInstalledLocalDeployer(jbossContainer);
        deployer.deploy(this.getDeployables());
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployDir, "cargocpc.war"));
    }

    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    public String toString() {
        return "JBoss Existing Configuration";
    }
}

