/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.junit;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.junit.MyTestRunner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class MyTestSuite
extends Suite
implements Traceable {
    private final Properties properties = this.readProperties();

    public MyTestSuite(Class<?> klass, RunnerBuilder runnerBuilder) throws InitializationError {
        super(klass, runnerBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Properties", this, "readProperties()");
        try {
            Properties properties = new Properties();
            File propertyFile = new File("." + File.separator + "integrationtest.properties");
            try (FileInputStream inputStream = new FileInputStream(propertyFile);){
                properties.load(inputStream);
            }
            catch (IOException ex) {
                tracer.logException(LogLevel.ERROR, ex, this.getClass(), "readProperties()");
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runChild(Runner runner, RunNotifier notifier) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, "runChild(Runner runner, RunNotifier notifier)");
        try {
            try {
                MyTestRunner myTestRunner = new MyTestRunner(runner.getDescription().getTestClass(), this.properties);
                super.runChild(myTestRunner, notifier);
            }
            catch (InitializationError error) {
                tracer.logException(LogLevel.FATAL, error, this.getClass(), "runChild(Runner runner, RunNotifier notifier)");
                notifier.pleaseStop();
            }
        }
        finally {
            tracer.wayout();
        }
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }
}

