/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package de.christofreichardt.junit;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/**
 *
 * @author Christof Reichardt
 */
public class MyTestSuite extends Suite implements Traceable {
  final private Properties properties;

  public MyTestSuite(Class<?> klass, RunnerBuilder runnerBuilder) throws InitializationError {
    super(klass, runnerBuilder);
    this.properties = readProperties();
  }
  
  private Properties readProperties() {
    AbstractTracer tracer = getCurrentTracer();
    tracer.entry("Properties", this, "readProperties()");
    
    try {
      Properties properties = new Properties();
      File propertyFile = new File("." + File.separator + "integrationtest.properties");
      try {
        try (FileInputStream inputStream = new FileInputStream(propertyFile)) {
          properties.load(inputStream);
        }
      }
      catch (IOException ex) {
        tracer.logException(LogLevel.ERROR, ex, getClass(), "readProperties()");
      }
      
      return properties;
    }
    finally {
      tracer.wayout();
    }
  }

  @Override
  protected void runChild(Runner runner, RunNotifier notifier) {
    AbstractTracer tracer = getCurrentTracer();
    tracer.entry("void", this, "runChild(Runner runner, RunNotifier notifier)");

    try {
//      tracer.out().printfIndentln("System.identityHashCode(runner) = %d", System.identityHashCode(runner));
//      tracer.out().printfIndentln("runner.getClass().getName() = %s", runner.getClass().getName());
//      tracer.out().printfIndentln("runner.getDescription().getDisplayName() = %s", runner.getDescription().getDisplayName());
//      tracer.out().printfIndentln("runner.getDescription().getTestClass().getName() = %s", runner.getDescription().getTestClass().getName());
//      tracer.out().printfIndentln("runner.testCount() = %d", runner.testCount());
//      
//      super.runChild(runner, notifier);
      
      try {
        MyTestRunner myTestRunner = new MyTestRunner(runner.getDescription().getTestClass(), this.properties);
//        Comparator<Description> comparator = new Comparator<Description>() {
//          @Override
//          public int compare(Description description1, Description description2) {
//            if ("mixedPriceRequest".equals(description1.getMethodName())) return -1;
//            else return 1;
//          }
//        };
//        myTestRunner.sort(new Sorter(comparator));
        super.runChild(myTestRunner, notifier);
      }
      catch (InitializationError error) {
        tracer.logException(LogLevel.FATAL, error, getClass(), "runChild(Runner runner, RunNotifier notifier)");
        notifier.pleaseStop();
      }
    }
    finally {
      tracer.wayout();
    }
  }
  
  @Override
  public AbstractTracer getCurrentTracer() {
    return TracerFactory.getInstance().getCurrentPoolTracer();
  }
}
