/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package de.christofreichardt.junit;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.util.Comparator;
import java.util.Properties;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Sorter;
import org.junit.runners.model.RunnerBuilder;

/**
 *
 * @author Christof Reichardt
 */
public class MyTestComputer extends Computer implements Traceable {
  
  final private Properties properties;

  public MyTestComputer(Properties properties) {
    this.properties = properties;
  }
  
  

  @Override
  protected Runner getRunner(RunnerBuilder runnerBuilder, Class<?> testClass) throws Throwable {
    AbstractTracer tracer = getCurrentTracer();
    tracer.entry("Runner", this, "getRunner(RunnerBuilder runnerBuilder, Class<?> testClass)");
    
    try {
      MyTestRunner myTestRunner = new MyTestRunner(testClass, this.properties);
      Sorter sorter = new Sorter(new Comparator<Description>() {
        @Override
        public int compare(Description description1, Description description2) {
          int ret;
          if ("replayAttack".equals(description1.getMethodName()))
            ret = 1;
          else if ("replayAttack".equals(description2.getMethodName()))
            ret = -1;
          else
            ret = 0;
          return ret;
        }
      });
      myTestRunner.sort(sorter);
      return myTestRunner;
    }
    finally {
      tracer.wayout();
    }
  }

  @Override
  public AbstractTracer getCurrentTracer() {
    return TracerFactory.getInstance().getCurrentPoolTracer();
  }
}
