/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package de.christofreichardt.jaxws.securitypriceservice;

import java.util.concurrent.atomic.AtomicLong;

/**
 *
 * @author Christof Reichardt
 */
public class TransactionIdCounter {
  
  private static final class InstanceHolder {
    static final TransactionIdCounter INSTANCE = new TransactionIdCounter();
  }
  
  static public TransactionIdCounter getInstance() {
    return InstanceHolder.INSTANCE;
  }
  
  private final AtomicLong transactionId = new AtomicLong();

  private TransactionIdCounter() {
  }

  public long getNextTransactionId() {
    return this.transactionId.getAndIncrement();
  }
}
