/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.ejb;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.cargo.module.DefaultJarArchive;
import org.codehaus.cargo.module.ejb.EjbArchive;
import org.codehaus.cargo.module.ejb.EjbJarXml;
import org.codehaus.cargo.module.ejb.EjbJarXmlIo;
import org.codehaus.cargo.module.ejb.jboss.JBossXml;
import org.codehaus.cargo.module.ejb.jboss.JBossXmlIo;
import org.codehaus.cargo.module.ejb.orion.OrionEjbJarXml;
import org.codehaus.cargo.module.ejb.orion.OrionEjbJarXmlIo;
import org.codehaus.cargo.module.ejb.weblogic.WeblogicEjbJarXml;
import org.codehaus.cargo.module.ejb.weblogic.WeblogicEjbJarXmlIo;
import org.codehaus.cargo.module.ejb.websphere.IbmEjbJarBndXmi;
import org.codehaus.cargo.module.ejb.websphere.IbmEjbJarBndXmiIo;
import org.jdom.JDOMException;

public class DefaultEjbArchive
extends DefaultJarArchive
implements EjbArchive {
    private EjbJarXml ejbJarXml;

    public DefaultEjbArchive(String file) {
        super(file);
    }

    public DefaultEjbArchive(InputStream theInputStream) throws IOException {
        super(theInputStream);
    }

    public EjbJarXml getEjbJarXml() throws IOException, JDOMException {
        if (this.ejbJarXml == null) {
            InputStream in = null;
            try {
                in = this.getResource("META-INF/ejb-jar.xml");
                this.ejbJarXml = EjbJarXmlIo.parseEjbJarXml(in, null);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.addWeblogicDescriptor();
            this.addOracleDescriptor();
            this.addWebsphereDescriptor();
            this.addJBossDescriptor();
        }
        return this.ejbJarXml;
    }

    private void addWeblogicDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            WeblogicEjbJarXml descr;
            in = this.getResource("META-INF/weblogic-ejb-jar.xml");
            if (in != null && (descr = WeblogicEjbJarXmlIo.parseWeblogicEjbJarXml(in)) != null) {
                this.ejbJarXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void addOracleDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            OrionEjbJarXml descr;
            in = this.getResource("META-INF/orion-ejb-jar.xml");
            if (in != null && (descr = OrionEjbJarXmlIo.parseOracleEjbJarXml(in)) != null) {
                this.ejbJarXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void addWebsphereDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            IbmEjbJarBndXmi descr;
            in = this.getResource("META-INF/ibm-ejb-jar-bnd.xmi");
            if (in != null && (descr = IbmEjbJarBndXmiIo.parseIbmEjbJarXmi(in)) != null) {
                this.ejbJarXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void addJBossDescriptor() throws IOException, JDOMException {
        InputStream in = null;
        try {
            JBossXml descr;
            in = this.getResource("META-INF/jboss.xml");
            if (in != null && (descr = JBossXmlIo.parseJBossXml(in)) != null) {
                this.ejbJarXml.addVendorDescriptor(descr);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

