/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.codehaus.cargo.container.ContainerException;

public class DefaultServerRun
extends Thread {
    private int port = 7777;
    private String host = "127.0.0.1";
    private String[] args;
    private boolean isStarted;

    public DefaultServerRun(String[] theArgs) {
        this.args = theArgs;
    }

    protected void doStartServer(String[] theArgs) throws Exception {
    }

    protected void doStopServer(String[] theArgs) throws Exception {
    }

    protected final void doRun() {
        boolean isStart = true;
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equalsIgnoreCase("-start")) {
                isStart = true;
                continue;
            }
            if (this.args[i].equalsIgnoreCase("-stop")) {
                isStart = false;
                continue;
            }
            if (this.args[i].equalsIgnoreCase("-port")) {
                this.port = Integer.parseInt(this.args[i + 1]);
                ++i;
                continue;
            }
            newArgs.add(this.args[i]);
        }
        String[] strArgs = new String[]{};
        this.args = newArgs.toArray(strArgs);
        if (isStart) {
            this.startServer();
        } else {
            this.stopServer();
        }
    }

    private void startServer() {
        if (this.isStarted) {
            return;
        }
        try {
            this.doStartServer(this.args);
        }
        catch (Exception e) {
            throw new ContainerException("Error starting server", e);
        }
        this.isStarted = true;
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopServer() {
        Socket clientSocket = null;
        try {
            try {
                clientSocket = new Socket(this.host, this.port);
            }
            catch (Exception e) {
                throw new ContainerException("Error opening socket to [" + this.host + ":" + this.port + "]", e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (clientSocket == null) throw throwable;
                clientSocket.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ContainerException("Cannot close client socket", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new ContainerException("Cannot close client socket", e);
        }
        if (clientSocket == null) return;
        clientSocket.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ServerSocket serverSocket = this.setUpListenerSocket();
        try {
            try {
                serverSocket.accept();
            }
            catch (IOException e) {
                throw new ContainerException("Error accepting connection for server socket [" + serverSocket + "]", e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                serverSocket.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ContainerException("Cannot close server socket [" + serverSocket + "]", e);
            }
        }
        try {}
        catch (IOException e) {
            throw new ContainerException("Cannot close server socket [" + serverSocket + "]", e);
        }
        serverSocket.close();
        try {
            this.doStopServer(this.args);
        }
        catch (Exception e) {
            throw new ContainerException("Cannot stop server", e);
        }
        try {
            serverSocket.close();
            return;
        }
        catch (IOException e) {
            throw new ContainerException("Cannot close server socket [" + serverSocket + "]", e);
        }
    }

    private ServerSocket setUpListenerSocket() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            throw new ContainerException("Error setting up the server listener socket", e);
        }
        return serverSocket;
    }
}

