/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jboss.internal.JBossContainerCapability;
import org.codehaus.cargo.container.jboss.internal.JBossInstalledLocalContainer;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;

public abstract class AbstractJBossInstalledLocalContainer
extends AbstractInstalledLocalContainer
implements JBossInstalledLocalContainer {
    private static final ContainerCapability CAPABILITY = new JBossContainerCapability();
    private String version;

    public AbstractJBossInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    protected void doStart(JvmLauncher java) throws Exception {
        java.setSystemProperty("java.endorsed.dirs", new File(this.getHome(), "/lib/endorsed").getAbsolutePath());
        java.setSystemProperty("jboss.home.dir", this.getHome());
        java.setSystemProperty("jboss.server.home.dir", this.getConfiguration().getHome());
        java.setSystemProperty("jboss.server.home.url", new File(this.getConfiguration().getHome()).toURI().toURL().toString());
        java.setSystemProperty("jboss.server.name", this.getConfiguration().getPropertyValue("cargo.jboss.configuration"));
        java.setSystemProperty("jboss.server.lib.url", new File(this.getConfiguration().getHome(), "lib").toURI().toURL().toString());
        java.setSystemProperty("jboss.server.log.threshold", this.getJBossLogLevel(this.getConfiguration().getPropertyValue("cargo.logging")));
        java.addAppArguments("--configuration=" + this.getConfiguration().getPropertyValue("cargo.jboss.configuration"));
        String runtimeArguments = this.getConfiguration().getPropertyValue("cargo.runtime.args");
        if (runtimeArguments == null || !runtimeArguments.contains("--host ") && !runtimeArguments.contains("-b ")) {
            String hostname = this.getConfiguration().getPropertyValue("cargo.hostname");
            if ("localhost".equals(hostname)) {
                hostname = "0.0.0.0";
            }
            java.addAppArguments("--host=" + hostname);
        }
        java.addClasspathEntries(new File(this.getHome(), "bin/run.jar"));
        this.addToolsJarToClasspath(java);
        java.setMainClass("org.jboss.Main");
        java.start();
    }

    protected void doStop(JvmLauncher java) throws Exception {
        java.addClasspathEntries(new File(this.getHome(), "bin/shutdown.jar"));
        java.setMainClass("org.jboss.Shutdown");
        java.addAppArguments("--server=" + this.getConfiguration().getPropertyValue("cargo.hostname") + ":" + this.getConfiguration().getPropertyValue("cargo.rmi.port"));
        String username = this.getConfiguration().getPropertyValue("cargo.remote.username");
        String password = this.getConfiguration().getPropertyValue("cargo.remote.password");
        if (username != null) {
            java.addAppArguments("--user=" + username);
            if (password != null) {
                java.addAppArguments("--password=" + password);
            }
        }
        java.execute();
    }

    protected final void verify() {
        super.verify();
        this.verifyJBossHome();
    }

    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    protected synchronized String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                JarFile jarFile = new JarFile(new File(this.getHome(), "bin/run.jar"));
                ZipEntry entry = jarFile.getEntry("org/jboss/version.properties");
                if (entry != null) {
                    Properties properties = new Properties();
                    properties.load(jarFile.getInputStream(entry));
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(properties.getProperty("version.major"));
                    buffer.append(".");
                    buffer.append(properties.getProperty("version.minor"));
                    buffer.append(".");
                    buffer.append(properties.getProperty("version.revision"));
                    version = buffer.toString();
                } else {
                    version = defaultVersion;
                    this.getLogger().debug("Couldn't find version.properties in " + jarFile.getName(), this.getClass().getName());
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getLogger().debug("Failed to find JBoss version, base error [" + e.getMessage() + "]", this.getClass().getName());
            }
            this.getLogger().info("Parsed JBoss version = [" + version + "]", this.getClass().getName());
            this.version = version;
        }
        return version;
    }

    public String getConfDir(String configurationName) {
        return this.getSpecificConfigurationDir("conf", configurationName);
    }

    public String getLibDir(String configurationName) {
        return this.getSpecificConfigurationDir("lib", configurationName);
    }

    public String getDeployDir(String configurationName) {
        String clustered = this.getConfiguration().getPropertyValue("cargo.jboss.clustered");
        if (Boolean.valueOf(clustered).booleanValue()) {
            return this.getSpecificConfigurationDir("farm", configurationName);
        }
        return this.getSpecificConfigurationDir("deploy", configurationName);
    }

    protected String getSpecificConfigurationDir(String location, String configurationName) {
        return this.getFileHandler().append(this.getHome(), "server/" + configurationName + "/" + location);
    }

    protected void verifyJBossHome() {
        String[] requiredJars;
        ArrayList<String> requiredDirs = new ArrayList<String>();
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "bin"));
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "client"));
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "lib"));
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "lib/endorsed"));
        requiredDirs.add(this.getFileHandler().append(this.getHome(), "server"));
        String errorPrefix = "Invalid JBoss installation. ";
        String errorSuffix = "Make sure the JBoss container home directory you have specified points to the right location (It's currently pointing to [" + this.getHome() + "])";
        for (String dir : requiredDirs) {
            if (!this.getFileHandler().exists(dir)) {
                throw new ContainerException(errorPrefix + "The [" + dir + "] directory doesn't exist. " + errorSuffix);
            }
            if (!this.getFileHandler().isDirectory(dir)) {
                throw new ContainerException(errorPrefix + "The [" + dir + "] path should be a directory. " + errorSuffix);
            }
            if (!this.getFileHandler().isDirectoryEmpty(dir)) continue;
            throw new ContainerException(errorPrefix + "The [" + dir + "] directory is empty and it shouldn't be. " + errorSuffix);
        }
        for (String requiredJar : requiredJars = new String[]{"bin/run.jar", "bin/shutdown.jar"}) {
            String jarFile = this.getFileHandler().append(this.getHome(), requiredJar);
            if (this.getFileHandler().exists(jarFile)) continue;
            throw new ContainerException(errorPrefix + "The [" + jarFile + "] JAR doesn't exist. " + errorSuffix);
        }
    }

    protected String getJBossLogLevel(String cargoLogLevel) {
        String returnVal = "INFO";
        if (LoggingLevel.LOW.equalsLevel(cargoLogLevel)) {
            returnVal = "WARN";
        } else if (LoggingLevel.HIGH.equalsLevel(cargoLogLevel)) {
            returnVal = "DEBUG";
        }
        return returnVal;
    }
}

