/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.jboss.JBoss7xInstalledLocalDeployer;
import org.codehaus.cargo.container.jboss.internal.JBoss7xStandaloneLocalConfigurationCapability;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.property.TransactionSupport;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.AbstractStandaloneLocalConfiguration;
import org.codehaus.cargo.util.CargoException;

public class JBoss7xStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfiguration {
    public static final String CONFIGURATION = "standalone";
    private static final ConfigurationCapability CAPABILITY = new JBoss7xStandaloneLocalConfigurationCapability();
    private MessageDigest md5;

    public JBoss7xStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1099");
        this.setProperty("cargo.jboss.jrmp.port", "1090");
        this.setProperty("cargo.jboss.jmx.port", "1091");
        this.setProperty("cargo.jboss.management-native.port", "9999");
        this.setProperty("cargo.jboss.management-http.port", "9990");
        this.setProperty("cargo.jboss.osgi.http.port", "8090");
        this.setProperty("cargo.jboss.remoting.transport.port", "4447");
        this.setProperty("cargo.jboss.configuration", CONFIGURATION);
        this.setProperty("cargo.jboss.modules.dir", "modules");
        this.getProperties().remove("cargo.jboss.ajp.port");
        this.getProperties().remove("cargo.jboss.classloading.webservice.port");
        this.getProperties().remove("cargo.jboss.ejb3.remoting.port");
        this.getProperties().remove("cargo.jboss.invoker.pool.port");
        this.getProperties().remove("cargo.jboss.jrmp.invoker.port");
        this.getProperties().remove("cargo.jboss.naming.port");
        this.getProperties().remove("cargo.jboss.transaction.recoveryManager.port");
        this.getProperties().remove("cargo.jboss.transaction.statusManager.port");
        try {
            this.md5 = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new CargoException("Cannot get the MD5 digest for generating the JBoss user properties files", e);
        }
    }

    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    protected void performXmlReplacements(LocalContainer container) {
        this.revertPortOffset();
        super.performXmlReplacements(container);
        this.applyPortOffset();
    }

    public void configure(LocalContainer container) {
        for (Deployable deployable : this.getDeployables()) {
            WAR war;
            if (!(deployable instanceof WAR) || (war = (WAR)deployable).getContext() != null && !war.getContext().equals("") && !war.getContext().equals("/") && !war.getContext().equalsIgnoreCase("ROOT")) continue;
            this.disableWelcomeRoot();
            break;
        }
        super.configure(container);
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            StringBuilder managementToken = new StringBuilder("# JBoss mgmt-users.properties file generated by CARGO\n");
            for (User user : User.parseUsers(this.getPropertyValue("cargo.servlet.users"))) {
                managementToken.append(this.generateUserPasswordLine(user, "ManagementRealm"));
            }
            this.getFileHandler().writeTextFile(this.getFileHandler().append(this.getHome(), "/configuration/mgmt-users.properties"), managementToken.toString(), "UTF-8");
        }
    }

    protected void disableWelcomeRoot() {
        String configurationXmlFile = "configuration/" + this.getPropertyValue("cargo.jboss.configuration") + ".xml";
        this.addXmlReplacement(configurationXmlFile, "//server/profile/subsystem/virtual-server", "enable-welcome-root", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConfigure(LocalContainer c) throws Exception {
        String deployments;
        if (!(c instanceof InstalledLocalContainer)) {
            throw new CargoException("Only InstalledLocalContainers are supported, got " + c.getClass().getName());
        }
        InstalledLocalContainer container = (InstalledLocalContainer)c;
        this.getLogger().info("Configuring JBoss using the [" + this.getPropertyValue("cargo.jboss.configuration") + "] server configuration", this.getClass().getName());
        this.setProperty("cargo.jboss.logging", this.getJBossLogLevel(this.getPropertyValue("cargo.logging")));
        String configurationXmlFile = "configuration/" + this.getPropertyValue("cargo.jboss.configuration") + ".xml";
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='http']", "port", "cargo.servlet.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='jndi']", "port", "cargo.rmi.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='jmx-connector-registry']", "port", "cargo.jboss.jrmp.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='jmx-connector-server']", "port", "cargo.jboss.jmx.port");
        this.addXmlReplacement(configurationXmlFile, "//server/management/management-interfaces/native-interface[@interface='management']", "port", "cargo.jboss.management-native.port");
        this.addXmlReplacement(configurationXmlFile, "//server/management/management-interfaces/http-interface[@interface='management']", "port", "cargo.jboss.management-http.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='osgi-http']", "port", "cargo.jboss.osgi.http.port");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group/socket-binding[@name='remoting']", "port", "cargo.jboss.remoting.transport.port");
        this.addXmlReplacement(configurationXmlFile, "//server/profile/subsystem/console-handler/level", "name", "cargo.jboss.logging");
        this.addXmlReplacement(configurationXmlFile, "//server/profile/subsystem/periodic-rotating-file-handler/level", "name", "cargo.jboss.logging");
        this.addXmlReplacement(configurationXmlFile, "//server/profile/subsystem/root-logger/level", "name", "cargo.jboss.logging");
        this.addXmlReplacement(configurationXmlFile, "//server/socket-binding-group", "port-offset", "cargo.port.offset");
        this.setupConfigurationDir();
        String initialConfiguration = this.getFileHandler().append(container.getHome(), CONFIGURATION);
        this.getFileHandler().copyDirectory(initialConfiguration, this.getHome());
        String configurationXML = this.getFileHandler().append(this.getHome(), configurationXmlFile);
        if (!this.getFileHandler().exists(configurationXML)) {
            throw new CargoException("Missing configuration XML file: " + configurationXML);
        }
        TreeSet<String> classpath = new TreeSet<String>();
        if (container.getExtraClasspath() != null && container.getExtraClasspath().length != 0) {
            for (String classpathElement : container.getExtraClasspath()) {
                classpath.add(classpathElement);
            }
        }
        if (container.getSharedClasspath() != null && container.getSharedClasspath().length != 0) {
            for (String classpathElement : container.getSharedClasspath()) {
                classpath.add(classpathElement);
            }
        }
        String tmpDir = this.getFileHandler().createUniqueTmpDirectory();
        try {
            ArrayList<String> driversList = new ArrayList<String>();
            StringBuilder datasources = new StringBuilder();
            StringBuilder drivers = new StringBuilder();
            for (DataSource dataSource : this.getDataSources()) {
                String dataSourceClass = dataSource.getDriverClass().replace('.', '/') + ".class";
                String dataSourceFile = null;
                for (String classpathElement : classpath) {
                    ZipFile zip = new ZipFile(classpathElement);
                    if (zip.getEntry(dataSourceClass) != null) {
                        dataSourceFile = classpathElement;
                    }
                    zip.close();
                }
                if (dataSourceFile == null) {
                    throw new CargoException("Datasource class " + dataSource.getDriverClass() + " not found in the classpath");
                }
                String moduleName = this.getFileHandler().getName(dataSourceFile);
                moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
                moduleName = moduleName.replace('.', '-');
                FilterChain filterChain = this.createFilterChain();
                this.getAntUtils().addTokenToFilterChain(filterChain, "moduleName", moduleName);
                this.getAntUtils().addTokenToFilterChain(filterChain, "driverClass", dataSource.getDriverClass());
                String jndiName = dataSource.getJndiLocation();
                if (!jndiName.startsWith("java:/")) {
                    jndiName = "java:/" + jndiName;
                    this.getLogger().warn("JBoss 7 requires datasource JNDI names to start with java:/, hence changing the given JNDI name to: " + jndiName, this.getClass().getName());
                }
                this.getAntUtils().addTokenToFilterChain(filterChain, "jndiName", jndiName);
                this.getAntUtils().addTokenToFilterChain(filterChain, "url", dataSource.getUrl());
                this.getAntUtils().addTokenToFilterChain(filterChain, "username", dataSource.getUsername());
                this.getAntUtils().addTokenToFilterChain(filterChain, "password", dataSource.getPassword());
                String xa = "";
                if (TransactionSupport.XA_TRANSACTION.equals(dataSource.getTransactionSupport())) {
                    xa = "-xa";
                }
                if (!driversList.contains(dataSource.getDriverClass())) {
                    driversList.add(dataSource.getDriverClass());
                    String temporaryDriver = this.getFileHandler().append(tmpDir, "driver.xml");
                    this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/jboss-ds/jboss-driver" + xa + ".xml", temporaryDriver, this.getFileHandler(), filterChain, "UTF-8");
                    drivers.append("\n");
                    drivers.append(this.getFileHandler().readTextFile(temporaryDriver, "UTF-8"));
                }
                String temporaryDatasource = this.getFileHandler().append(tmpDir, "datasource.xml");
                this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/jboss-ds/jboss-datasource.xml", temporaryDatasource, this.getFileHandler(), filterChain, "UTF-8");
                datasources.append("\n");
                datasources.append(this.getFileHandler().readTextFile(temporaryDatasource, "UTF-8"));
            }
            HashMap<String, String> replacements = new HashMap<String, String>(1);
            replacements.put("<drivers>", datasources + "<drivers>" + drivers);
            this.getFileHandler().replaceInFile(configurationXML, replacements, "UTF-8");
        }
        finally {
            this.getFileHandler().delete(tmpDir);
        }
        String altDeployDir = container.getConfiguration().getPropertyValue("cargo.jboss.deployment.dir");
        if (altDeployDir != null && !altDeployDir.equals("")) {
            container.getLogger().info("Using non-default deployment target directory " + altDeployDir, this.getClass().getName());
            deployments = this.getFileHandler().append(this.getHome(), altDeployDir);
        } else {
            deployments = this.getFileHandler().append(this.getHome(), "deployments");
        }
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployments, "cargocpc.war"));
        JBoss7xInstalledLocalDeployer deployer = new JBoss7xInstalledLocalDeployer(container);
        deployer.deploy(this.getDeployables());
    }

    protected String generateUserPasswordLine(User user, String realm) {
        byte[] hash;
        String toHash = user.getName() + ":" + realm + ":" + user.getPassword();
        try {
            hash = this.md5.digest(toHash.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CargoException("Cannot encode one line for the application-users.properties file", e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(user.getName());
        sb.append("=");
        for (byte hashByte : hash) {
            sb.append(String.format("%02x", hashByte));
        }
        sb.append('\n');
        return sb.toString();
    }

    private String getJBossLogLevel(String cargoLogLevel) {
        String level = LoggingLevel.LOW.equalsLevel(cargoLogLevel) ? "ERROR" : (LoggingLevel.MEDIUM.equalsLevel(cargoLogLevel) ? "INFO" : "DEBUG");
        return level;
    }
}

