/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.ConfigurationCapability;
import org.codehaus.cargo.container.jboss.JBoss7xInstalledLocalDeployer;
import org.codehaus.cargo.container.jboss.internal.JBoss7xExistingLocalConfigurationCapability;
import org.codehaus.cargo.container.spi.configuration.AbstractExistingLocalConfiguration;
import org.codehaus.cargo.container.spi.deployer.AbstractDeployer;

public class JBoss7xExistingLocalConfiguration
extends AbstractExistingLocalConfiguration {
    private static final ConfigurationCapability CAPABILITY = new JBoss7xExistingLocalConfigurationCapability();

    public JBoss7xExistingLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.rmi.port", "1099");
        this.setProperty("cargo.jboss.configuration", "standalone");
        this.setProperty("cargo.jboss.jrmp.port", "1090");
        this.setProperty("cargo.jboss.jmx.port", "1091");
        this.setProperty("cargo.jboss.management-native.port", "9999");
        this.setProperty("cargo.jboss.modules.dir", "modules");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        File deployDir;
        InstalledLocalContainer jbossContainer = (InstalledLocalContainer)container;
        String altDeployDir = container.getConfiguration().getPropertyValue("cargo.jboss.deployment.dir");
        if (altDeployDir != null && !altDeployDir.equals("")) {
            container.getLogger().info("Using non-default deployment target directory " + altDeployDir, this.getClass().getName());
            deployDir = new File(this.getHome(), altDeployDir);
        } else {
            deployDir = new File(this.getHome(), "deployments");
        }
        if (!deployDir.exists()) {
            throw new ContainerException("Invalid existing configuration: The [" + deployDir.getPath() + "] directory does not exist");
        }
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", new File(deployDir, "cargocpc.war"));
        AbstractDeployer deployer = this.createDeployer(jbossContainer);
        deployer.deploy(this.getDeployables());
    }

    protected AbstractDeployer createDeployer(InstalledLocalContainer jbossContainer) {
        return new JBoss7xInstalledLocalDeployer(jbossContainer);
    }

    public ConfigurationCapability getCapability() {
        return CAPABILITY;
    }

    public String toString() {
        return "JBoss Existing Configuration";
    }
}

