/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jboss.JBoss7xInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;

public class JBoss71xInstalledLocalContainer
extends JBoss7xInstalledLocalContainer {
    public static final String ID = "jboss71x";
    private boolean firstAttemptStopping = true;

    public JBoss71xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "JBoss " + this.getVersion("7.1.x");
    }

    protected void doStart(JvmLauncher java) throws Exception {
        this.copyExtraClasspathJars();
        this.setProperties(java);
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        String modules = this.getConfiguration().getPropertyValue("cargo.jboss.modules.dir");
        if (!new File(modules).isAbsolute()) {
            modules = this.getFileHandler().append(this.getHome(), modules);
        }
        java.addAppArguments("-mp", modules, "-jaxpmodule", "javax.xml.jaxp-provider", "org.jboss.as.standalone", "--server-config=" + this.getConfiguration().getPropertyValue("cargo.jboss.configuration") + ".xml");
        String runtimeArgs = this.getConfiguration().getPropertyValue("cargo.runtime.args");
        if (runtimeArgs != null) {
            runtimeArgs = runtimeArgs.replace('\n', ' ');
            runtimeArgs = runtimeArgs.replace('\r', ' ');
            runtimeArgs = runtimeArgs.replace('\t', ' ');
            java.addAppArgumentLine(runtimeArgs);
        }
        java.start();
    }

    protected void doStop(JvmLauncher java) throws Exception {
        String host = this.getConfiguration().getPropertyValue("cargo.hostname");
        String port = this.getConfiguration().getPropertyValue("cargo.jboss.management-native.port");
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        java.addAppArguments("-mp", this.getHome() + "/modules", "org.jboss.as.cli", "--connect", "--controller=" + host + ":" + port, "command=:shutdown");
        String username = this.getConfiguration().getPropertyValue("cargo.remote.username");
        if (username != null && username.trim().length() != 0) {
            String password = this.getConfiguration().getPropertyValue("cargo.remote.password");
            java.addAppArguments("--user=" + username, "--password=" + password);
        }
        java.start();
    }

    protected void waitForCompletion(boolean waitForStarting) throws InterruptedException {
        if (!waitForStarting) {
            try {
                super.waitForCompletion(waitForStarting);
            }
            catch (ContainerException e) {
                if (this.firstAttemptStopping) {
                    this.getLogger().debug("First attempt to stop the JBoss server has failed (" + e + "), trying one last time", this.getClass().getName());
                    this.firstAttemptStopping = false;
                    this.stop();
                }
                throw e;
            }
        } else {
            super.waitForCompletion(waitForStarting);
        }
    }
}

