/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import de.christofreichardt.diagnosis.AbstractThreadMap;
import de.christofreichardt.diagnosis.DebugConfig;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.ThreadLocalMap;
import de.christofreichardt.diagnosis.TraceMethod;
import de.christofreichardt.diagnosis.TracingContext;
import de.christofreichardt.diagnosis.io.IndentablePrintStream;
import de.christofreichardt.diagnosis.io.NullOutputStream;
import de.christofreichardt.diagnosis.io.NullPrintStream;
import de.christofreichardt.diagnosis.io.TracePrintStream;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTracer {
    public static final String VERSION = "1.7.1";
    private final String name;
    private boolean opened = false;
    private boolean autoflush = true;
    private int bufferSize = 512;
    private final NullPrintStream nullPrintStream;
    private BufferedOutputStream bufferedOutputStream = null;
    private TracePrintStream tracePrintStream = null;
    private final AbstractThreadMap threadMap = new ThreadLocalMap();
    private final Map<String, DebugConfig> debugConfigMap = new ConcurrentHashMap<String, DebugConfig>();
    private final Object syncObject = new Object();

    public AbstractTracer(String name) {
        if (name == null) {
            throw new NullPointerException("Need a name for the tracer.");
        }
        this.name = name;
        this.nullPrintStream = new NullPrintStream();
        this.tracePrintStream = new TracePrintStream((OutputStream)new NullOutputStream(), this.threadMap);
    }

    public String getName() {
        return this.name;
    }

    public boolean isOpened() {
        return this.opened;
    }

    protected void setOpened(boolean opened) {
        this.opened = opened;
    }

    public boolean isAutoflush() {
        return this.autoflush;
    }

    protected void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Object getSyncObject() {
        return this.syncObject;
    }

    protected NullPrintStream getNullPrintStream() {
        return this.nullPrintStream;
    }

    protected BufferedOutputStream getBufferedOutputStream() {
        return this.bufferedOutputStream;
    }

    protected void setBufferedOutputStream(BufferedOutputStream bufferedOutputStream) {
        this.bufferedOutputStream = bufferedOutputStream;
    }

    protected TracePrintStream getTracePrintStream() {
        return this.tracePrintStream;
    }

    protected void setTracePrintStream(TracePrintStream tracePrintStream) {
        this.tracePrintStream = tracePrintStream;
    }

    protected AbstractThreadMap getThreadMap() {
        return this.threadMap;
    }

    protected void readConfiguration(XPath xpath, Node node) throws XPathExpressionException, Exception {
        this.autoflush = "true".equals((String)xpath.evaluate("./dns:AutoFlush/text()", node, XPathConstants.STRING));
        this.bufferSize = Integer.parseInt((String)xpath.evaluate("./dns:BufSize/text()", node, XPathConstants.STRING));
        System.out.println("this.autoflush = " + this.autoflush);
        System.out.println("this.bufferSize = " + this.bufferSize);
        NodeList threadNodes = (NodeList)xpath.evaluate("./dns:Context/dns:Thread", node, XPathConstants.NODESET);
        for (int i = 0; i < threadNodes.getLength(); ++i) {
            String threadName = threadNodes.item(i).getAttributes().getNamedItem("name").getNodeValue();
            boolean online = "true".equals((String)xpath.evaluate("./dns:Online/text()", threadNodes.item(i), XPathConstants.STRING));
            int debugLevel = Integer.parseInt((String)xpath.evaluate("./dns:DebugLevel/text()", threadNodes.item(i), XPathConstants.STRING));
            System.out.println("(*-*)");
            System.out.println("threadName = " + threadName);
            System.out.println("online = " + online);
            System.out.println("debugLevel = " + debugLevel);
            this.debugConfigMap.put(threadName, new DebugConfig(online, debugLevel));
        }
    }

    public abstract void open();

    public abstract void close();

    public IndentablePrintStream out() {
        return this.out(this.threadMap.getCurrentStackSize());
    }

    protected IndentablePrintStream out(int level) {
        TracingContext tracingContext;
        IndentablePrintStream printStream = level >= 0 ? ((tracingContext = this.threadMap.getCurrentTracingContext()) != null && tracingContext.isOnline() && tracingContext.getDebugLevel() >= level ? this.tracePrintStream : this.nullPrintStream) : this.nullPrintStream;
        return printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public TraceMethod entry(String methodSignature) {
        Object object = this.syncObject;
        synchronized (object) {
            this.out().printIndentln("ENTRY--" + methodSignature + "--" + Thread.currentThread().getName() + "[" + Thread.currentThread().getId() + "]");
        }
        TraceMethod traceMethod = null;
        try {
            traceMethod = new TraceMethod(methodSignature);
            if (!this.threadMap.push(traceMethod)) {
                traceMethod = null;
            }
        }
        catch (AbstractThreadMap.RuntimeException ex) {
            this.logMessage(LogLevel.SEVERE, "Stacksize is exceeded. Tracing is off.", this.getClass(), "entry()");
        }
        return traceMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMethodEntry(String methodSignature) {
        Object object = this.syncObject;
        synchronized (object) {
            this.out().printIndentln("ENTRY--" + methodSignature + "--" + Thread.currentThread().getName() + "[" + Thread.currentThread().getId() + "]");
        }
    }

    public TraceMethod entry(String returnType, Object object, String methodSignature) {
        TraceMethod traceMethod;
        if (object != null) {
            traceMethod = new TraceMethod(returnType, object, methodSignature);
            methodSignature = traceMethod.getSignature();
        } else {
            methodSignature = returnType + " " + methodSignature;
            traceMethod = new TraceMethod(methodSignature);
        }
        this.printMethodEntry(methodSignature);
        try {
            if (!this.threadMap.push(traceMethod)) {
                traceMethod = null;
            }
        }
        catch (AbstractThreadMap.RuntimeException ex) {
            this.logMessage(LogLevel.SEVERE, "Stacksize is exceeded. Tracing is off.", this.getClass(), "entry()");
        }
        return traceMethod;
    }

    public TraceMethod entry(String returnType, Class clazz, String methodSignature) {
        TraceMethod traceMethod;
        if (clazz != null) {
            traceMethod = new TraceMethod(returnType, clazz, methodSignature);
            methodSignature = traceMethod.getSignature();
        } else {
            methodSignature = returnType + " " + methodSignature;
            traceMethod = new TraceMethod(methodSignature);
        }
        this.printMethodEntry(methodSignature);
        try {
            if (!this.threadMap.push(traceMethod)) {
                traceMethod = null;
            }
        }
        catch (AbstractThreadMap.RuntimeException ex) {
            this.logMessage(LogLevel.SEVERE, "Stacksize is exceeded. Tracing is off.", this.getClass(), "entry()");
        }
        return traceMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceMethod wayout() {
        TraceMethod traceMethod;
        block6: {
            traceMethod = null;
            try {
                traceMethod = this.threadMap.pop();
                if (traceMethod == null) break block6;
                Object object = this.syncObject;
                synchronized (object) {
                    this.out().printIndentln("RETURN-" + traceMethod.getSignature() + "--(+" + traceMethod.getElapsedTime() + "ms)--" + "(+" + traceMethod.getElapsedCpuTime() + "ms)--" + Thread.currentThread().getName() + "[" + Thread.currentThread().getId() + "]");
                    if (this.autoflush) {
                        this.out().flush();
                    }
                }
            }
            catch (AbstractThreadMap.RuntimeException ex) {
                this.logMessage(LogLevel.SEVERE, "Stack is corrupted. Tracing is off.", this.getClass(), "wayout()");
            }
        }
        return traceMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(LogLevel logLevel, String message, Class clazz, String methodName) {
        Date timeStamp = new Date();
        char[] border = new char[logLevel.toString().length() + 4];
        Arrays.fill(border, '*');
        Object object = this.syncObject;
        synchronized (object) {
            this.tracePrintStream.println(border);
            this.tracePrintStream.printf("* %s *  [%tc] [%d,%s] [%s] [%s] \"%s\"%n", logLevel.toString(), timeStamp, Thread.currentThread().getId(), Thread.currentThread().getName(), clazz.getName(), methodName, message);
            this.tracePrintStream.println(border);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logException(LogLevel logLevel, Throwable throwable, Class clazz, String methodName) {
        String message;
        Date timeStamp = new Date();
        char[] border = new char[logLevel.toString().length() + 4];
        Arrays.fill(border, '*');
        if (throwable.getMessage() != null) {
            message = throwable.getMessage().trim();
            message = message.replace(System.getProperty("line.separator"), " => ");
        } else {
            message = "No message.";
        }
        Object object = this.syncObject;
        synchronized (object) {
            this.tracePrintStream.println(border);
            this.tracePrintStream.printf("* %s *  [%tc] [%d,%s] [%s] [%s] \"%s\"%n", logLevel.toString(), timeStamp, Thread.currentThread().getId(), Thread.currentThread().getName(), clazz.getName(), methodName, message);
            this.tracePrintStream.println(border);
            throwable.printStackTrace(this.tracePrintStream);
        }
    }

    public void initCurrentTracingContext(int debugLevel, boolean online) {
        TracingContext tracingContext = this.threadMap.getCurrentTracingContext();
        if (tracingContext == null) {
            System.out.println(this.formatContextInfo(debugLevel, online));
            tracingContext = new TracingContext(debugLevel, online);
            this.threadMap.setCurrentTracingContext(tracingContext);
        } else {
            tracingContext.setDebugLevel(debugLevel);
            tracingContext.setOnline(online);
        }
    }

    public void initCurrentTracingContext() {
        TracingContext tracingContext = this.threadMap.getCurrentTracingContext();
        if (tracingContext == null && this.debugConfigMap.containsKey(Thread.currentThread().getName())) {
            DebugConfig debugConfig = this.debugConfigMap.get(Thread.currentThread().getName());
            System.out.println(this.formatContextInfo(debugConfig.getLevel(), debugConfig.isOnline()));
            tracingContext = new TracingContext(debugConfig);
            this.threadMap.setCurrentTracingContext(tracingContext);
        }
    }

    public void clearCurrentTracingContext() {
        this.threadMap.removeCurrentTracingContext();
    }

    protected String substitute(String expression) throws Exception {
        boolean flag;
        Pattern compiledPattern = Pattern.compile("\\$\\{[a-zA-Z0-9.]+\\}");
        Matcher matcher = compiledPattern.matcher(expression);
        int pos = 0;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            flag = false;
            while (matcher.find()) {
                stringBuilder.append(expression.substring(pos, matcher.start()));
                String propertyKey = expression.substring(matcher.start() + 2, matcher.end() - 1);
                if (System.getProperties().containsKey(propertyKey)) {
                    String propertyValue = System.getProperty(propertyKey);
                    stringBuilder.append(propertyValue);
                    pos = matcher.end();
                    flag = true;
                    continue;
                }
                throw new Exception("Unknown property key.");
            }
            stringBuilder.append(expression.substring(pos));
            expression = stringBuilder.toString();
            if (!flag) continue;
            stringBuilder = new StringBuilder();
            matcher.reset(expression);
            pos = 0;
        } while (flag);
        return expression;
    }

    private String formatContextInfo(int debugLevel, boolean online) {
        Formatter formatter = new Formatter();
        formatter.format("TraceLogger[%s]: Initialising tracing context for Thread[id=%d,name=%s] with debugLevel=%d and online=%b ... ", this.name, Thread.currentThread().getId(), Thread.currentThread().getName(), debugLevel, online);
        return formatter.toString();
    }

    protected String formatStreamErrorState() {
        Formatter formatter = new Formatter();
        formatter.format("TraceLogger[%s]: Stream error state = %s.", this.name, this.tracePrintStream.checkError() ? "bad" : "ok");
        return formatter.toString();
    }

    protected String formatVersionInfo() {
        Formatter formatter = new Formatter();
        formatter.format("TraceLogger[%s]: Version = %s.", this.name, VERSION);
        return formatter.toString();
    }

    public class Exception
    extends java.lang.Exception {
        public Exception(String msg) {
            super(msg);
        }

        public Exception(Throwable cause) {
            super(cause);
        }
    }
}

