/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

/**
 *
 * @author Christof Reichardt
 */
public class PriceExtractorUnit implements Traceable {
  static public final String CHARSET = "UTF-8";

  @Test
  @Ignore
  public void extractShare() throws IOException {
    AbstractTracer tracer = getCurrentTracer();
    tracer.entry("void", this, "extractShare()");
    
    try {
      Document document = Jsoup.connect("http://www.onvista.de/aktien/SAP-Aktie-DE0007164600").timeout(5000).userAgent("Mozilla").get();
      
      tracer.out().printfIndentln("document.title() = %s", document.title());
      
      Element span = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article ul.KURSDATEN li span").first();
      Assert.assertNotNull(span);
      tracer.out().printfIndentln("span.text() = %s", span.text());
      
      span = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article table.KURSDATEN tbody tr td.BRIEF span").first();
      Assert.assertNotNull(span);
      tracer.out().printfIndentln("span.text() = %s", span.text());
      
      span = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article table.KURSDATEN tbody tr td.GELD span").first();
      Assert.assertNotNull(span);
      tracer.out().printfIndentln("span.text() = %s", span.text());
    }
    finally {
      tracer.wayout();
    }
  }
  
  @Test
  @Ignore
  public void searchShareByISIN() throws IOException {
    AbstractTracer tracer = getCurrentTracer();
    tracer.entry("void", this, "searchShareByISIN()");
    
    try {
      Map<String,String> isin2Sharename = new HashMap<>();
      isin2Sharename.put("DE0007664039", "Volkswagen VZ");
      isin2Sharename.put("DE000CBK1001", "Commerzbank");
      isin2Sharename.put("DE000KSAG888", "K+S");
      isin2Sharename.put("DE0008232125", "Lufthansa");
      isin2Sharename.put("DE0005439004", "Continental");
      isin2Sharename.put("DE0005140008", "Deutsche Bank");
      isin2Sharename.put("DE0006047004", "HeidelbergCement");
      
      for (String isin : isin2Sharename.keySet()) {
        Document document = Jsoup.connect("http://www.onvista.de/suche/" + isin).timeout(10000).userAgent("Mozilla").get();
        
        Element anchor = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article div.WERTPAPIER span.WERTPAPIERNAME a.INSTRUMENT").first();
        Assert.assertNotNull("Cannot access name.", anchor);
        tracer.out().printfIndentln("%s: %s", isin, anchor.text());
        String expectedSharename = isin2Sharename.get(isin) + " Aktie";
        Assert.assertTrue("Expected: " + expectedSharename, expectedSharename.equals(anchor.text()));
        Elements elements = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article div.WERTPAPIER_DETAILS dl dd");
        tracer.out().printfIndentln("elements.size() = %d", elements.size());
//        for (Element el : elements) {
//          tracer.out().printfIndentln("el.text() = %s", el.text());
//        }
        Assert.assertTrue("Expected 6 elements", elements.size() == 6);
        Element wknEl = elements.first();
        Element isinEl = elements.get(1);
        tracer.out().printfIndentln("wknEl.text() = %s", wknEl.text());
        tracer.out().printfIndentln("isinEl.text() = %s", isinEl.text());
        
        Element termSpan = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article div.WERTPAPIER span.WERTPAPIERNAME a.INSTRUMENT span.INSTRUMENT.AKTIE").first();
        Assert.assertNotNull("Cannot access term.", termSpan);
        tracer.out().printfIndentln("termSpan.text() = %s", termSpan.text());
        Assert.assertTrue("Expected: 'Aktie'", "Aktie".equals(termSpan.text()));
        
        Element rateSpan = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article ul.KURSDATEN li span").first();
        Assert.assertNotNull("Cannot access rate.", rateSpan);
        tracer.out().printfIndentln("rateSpan.text() = %s", rateSpan.text());
        
        Element bidSpan = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article table.KURSDATEN tbody tr td.BRIEF span").first();
        Assert.assertNotNull("Cannot access bid.", bidSpan);
        tracer.out().printfIndentln("bidSpan.text() = %s", bidSpan.text());
        
        Element askSpan = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT article table.KURSDATEN tbody tr td.GELD span").first();
        Assert.assertNotNull("Cannot access bid.", askSpan);
        tracer.out().printfIndentln("askSpan.text() = %s", askSpan.text());
        
        tracer.out().printfIndentln("--------------------------");
      }
    }
    finally {
      tracer.wayout();
    }
  }
  
  @Test
  @Ignore
  public void searchOptionByIsin() throws IOException {
    AbstractTracer tracer = getCurrentTracer();
    tracer.entry("void", this, "searchOptionByIsin()");
    
    try {
      Map<String,String> isin2Optionname = new HashMap<>();
      isin2Optionname.put("DE000HY2W8B2", "CALL auf DEUTSCHE TELEKOM");
      isin2Optionname.put("CH0234840814", "CALL auf COMMERZBANK");
      isin2Optionname.put("DE000DT62Q68", "CALL auf DAX Performance-Index");
      isin2Optionname.put("CH0239370593", "CALL auf DAX Performance-Index");
      isin2Optionname.put("DE000DE8C4L9", "CALL auf DAX Performance-Index");
      isin2Optionname.put("DE000DZP8V34", "CALL auf DAX Performance-Index");
      
      for (String isin : isin2Optionname.keySet()) {
        Document document = Jsoup.connect("http://www.onvista.de/suche/" + isin).timeout(10000).userAgent("Mozilla").get();
        
        Element h1 = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT h1.EINZELANSICHTEN").first();
        Assert.assertNotNull("Cannot access name.", h1);
        tracer.out().printfIndentln("%s: %s", isin, h1.text());
        String expectedOptionname = isin2Optionname.get(isin);
        Assert.assertTrue("Expected: " + expectedOptionname, expectedOptionname.equals(h1.text()));
        
        Element category = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT span.skb").first();
        Assert.assertNotNull("Cannot access category.", category);
        tracer.out().printfIndentln("category.text() = %s", category.text());
        Assert.assertTrue("Expected: 'Kategorie: Standard Optionsscheine'", category.text().startsWith("Kategorie: Standard Optionsscheine"));
        
        Elements elements = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT div.t table.weiss.abst tbody tr.hgrau2 td");
        tracer.out().printfIndentln("elements.size() = %d", elements.size());
        Assert.assertTrue("Expected minimal 15 elements", elements.size() >= 15);
        
        Element wknEl = elements.get(1);
        Element isinEl = elements.get(3);
        Element strikePriceEl = elements.get(11);
        
        tracer.out().printfIndentln("wknEl.text() = %s", wknEl.text());
        tracer.out().printfIndentln("isinEl.text() = %s", isinEl.text());
        tracer.out().printfIndentln("strikePriceEl.text() = %s", strikePriceEl.text());
        Assert.assertTrue("Wrong ISIN.", isin.equals(isinEl.text()));
        
        Elements tables = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT div.t table.weiss.abst");
        tracer.out().printfIndentln("tables.size() = %d", tables.size());
        Assert.assertTrue("Expected minimal 3 tables", tables.size() >= 3);
        Element ratesTable = tables.get(2);
        Elements spans = ratesTable.select("tbody tr td span");
        tracer.out().printfIndentln("spans.size() = %d", spans.size());
        Assert.assertTrue("Expected minimal 4 elements", spans.size() >= 4);
        tracer.out().printfIndentln("bid = %s", spans.get(1).text());
        tracer.out().printfIndentln("ask = %s", spans.get(3).text());
        
        Element table = document.select("div#ONVISTA div.WEBSEITE div.CONTAINER1 div.INHALT div.hp_50_r div.t table.weiss").last();
        Assert.assertNotNull("Cannot access expirationDate and exercise.", table);
        Elements tds = table.select("tbody tr td");
        tracer.out().printfIndentln("tds.size() = %d", tds.size());
        Assert.assertTrue("Expected minimal 16 table cells", elements.size() >= 16);
        
        Element expirationDate = tds.get(11);
        Element exercise = tds.get(15);
        
        tracer.out().printfIndentln("expirationDate.text() = %s", expirationDate.text());
        tracer.out().printfIndentln("exercise.text() = %s", exercise.text());
        
        tracer.out().printfIndentln("--------------------------");
      }
    }
    finally {
      tracer.wayout();
    }
  }

  @Override
  public AbstractTracer getCurrentTracer() {
    return TracerFactory.getInstance().getCurrentPoolTracer();
  }
}
