package de.christofreichardt.jaxws.securitypriceservice;

import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * <p>
 * Java class for SharePrice complex type.
 *
 * <p>
 * The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="SharePrice">
 *   &lt;complexContent>
 *     &lt;extension base="{http://de.christofreichardt/SecurityPriceService}AbstractSecurityPrice">
 *       &lt;sequence>
 *         &lt;element name="Rate" type="{http://www.w3.org/2001/XMLSchema}decimal"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SharePrice", propOrder = {
  "rate"
})
public class SharePrice
    extends AbstractSecurityPrice {

  @XmlElement(name = "Rate", required = true)
  protected BigDecimal rate;

  /**
   * Gets the value of the rate property.
   *
   * @return possible object is {@link BigDecimal }
   *
   */
  public BigDecimal getRate() {
    return rate;
  }

  /**
   * Sets the value of the rate property.
   *
   * @param value allowed object is {@link BigDecimal }
   *
   */
  public void setRate(BigDecimal value) {
    this.rate = value;
  }

  @Override
  public String toString() {
    StringBuilder stringBuilder = new StringBuilder();
    stringBuilder.append("SharePrice[");
    if (this.security != null) {
      stringBuilder.append("Security[");
      stringBuilder.append("Name=");
      stringBuilder.append(this.security.getName());
      stringBuilder.append(", ");
      stringBuilder.append("WKN=");
      stringBuilder.append(this.security.getWKN());
      stringBuilder.append(", ");
      stringBuilder.append("ISIN=");
      stringBuilder.append(this.security.getISIN());
      stringBuilder.append("]");
    }
    stringBuilder.append("Ask=");
    stringBuilder.append(this.getAsk());
    stringBuilder.append(", ");
    stringBuilder.append("Bid=");
    stringBuilder.append(this.getBid());
    stringBuilder.append(", ");
    stringBuilder.append("Rate=");
    stringBuilder.append(this.getRate());
    stringBuilder.append("]");

    return stringBuilder.toString();
  }

}
