package de.christofreichardt.jaxws.securitypriceservice;

import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

/**
 * <p>
 * Java class for OptionPrice complex type.
 *
 * <p>
 * The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="OptionPrice">
 *   &lt;complexContent>
 *     &lt;extension base="{http://de.christofreichardt/SecurityPriceService}AbstractSecurityPrice">
 *       &lt;sequence>
 *         &lt;element name="StrikePrice" type="{http://www.w3.org/2001/XMLSchema}decimal"/>
 *         &lt;element name="ExpirationDate" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>
 *         &lt;element name="Exercise" type="{http://de.christofreichardt/SecurityPriceService}Exercise"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OptionPrice", propOrder = {
  "strikePrice",
  "expirationDate",
  "exercise"
})
public class OptionPrice
    extends AbstractSecurityPrice {

  @XmlElement(name = "StrikePrice", required = true)
  protected BigDecimal strikePrice;
  @XmlElement(name = "ExpirationDate", required = true)
  @XmlSchemaType(name = "dateTime")
  protected XMLGregorianCalendar expirationDate;
  @XmlElement(name = "Exercise", required = true)
  protected Exercise exercise;

  /**
   * Gets the value of the strikePrice property.
   *
   * @return possible object is {@link BigDecimal }
   *
   */
  public BigDecimal getStrikePrice() {
    return strikePrice;
  }

  /**
   * Sets the value of the strikePrice property.
   *
   * @param value allowed object is {@link BigDecimal }
   *
   */
  public void setStrikePrice(BigDecimal value) {
    this.strikePrice = value;
  }

  /**
   * Gets the value of the expirationDate property.
   *
   * @return possible object is {@link XMLGregorianCalendar }
   *
   */
  public XMLGregorianCalendar getExpirationDate() {
    return expirationDate;
  }

  /**
   * Sets the value of the expirationDate property.
   *
   * @param value allowed object is {@link XMLGregorianCalendar }
   *
   */
  public void setExpirationDate(XMLGregorianCalendar value) {
    this.expirationDate = value;
  }

  /**
   * Gets the value of the exercise property.
   *
   * @return possible object is {@link Exercise }
   *
   */
  public Exercise getExercise() {
    return exercise;
  }

  /**
   * Sets the value of the exercise property.
   *
   * @param value allowed object is {@link Exercise }
   *
   */
  public void setExercise(Exercise value) {
    this.exercise = value;
  }

  @Override
  public String toString() {
    StringBuilder stringBuilder = new StringBuilder();
    stringBuilder.append("OptionPrice[");
    if (this.security != null) {
      stringBuilder.append("Security[");
      stringBuilder.append("Name=");
      stringBuilder.append(this.security.getName());
      stringBuilder.append(", ");
      stringBuilder.append("WKN=");
      stringBuilder.append(this.security.getWKN());
      stringBuilder.append(", ");
      stringBuilder.append("ISIN=");
      stringBuilder.append(this.security.getISIN());
      stringBuilder.append("]");
    }
    stringBuilder.append("Ask=");
    stringBuilder.append(this.getAsk());
    stringBuilder.append(", ");
    stringBuilder.append("Bid=");
    stringBuilder.append(this.getBid());
    stringBuilder.append(", ");
    stringBuilder.append("Exercise=");
    stringBuilder.append(this.getExercise());
    stringBuilder.append(", ");
    stringBuilder.append("ExpirationDate=");
    stringBuilder.append(this.getExpirationDate());
    stringBuilder.append(", ");
    stringBuilder.append("StrikePrice=");
    stringBuilder.append(this.getStrikePrice());
    stringBuilder.append("]");

    return stringBuilder.toString();
  }

}
