package de.christofreichardt.jaxws.securitypriceservice;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * <p>
 * Java class for IndexPrice complex type.
 *
 * <p>
 * The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="IndexPrice">
 *   &lt;complexContent>
 *     &lt;extension base="{http://de.christofreichardt/SecurityPriceService}AbstractSecurityPrice">
 *       &lt;sequence>
 *         &lt;element name="Issuer" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "IndexPrice", propOrder = {
  "issuer"
})
public class IndexPrice
    extends AbstractSecurityPrice {

  @XmlElement(name = "Issuer", required = true)
  protected String issuer;

  /**
   * Gets the value of the issuer property.
   *
   * @return possible object is {@link String }
   *
   */
  public String getIssuer() {
    return issuer;
  }

  /**
   * Sets the value of the issuer property.
   *
   * @param value allowed object is {@link String }
   *
   */
  public void setIssuer(String value) {
    this.issuer = value;
  }

  @Override
  public String toString() {
    StringBuilder stringBuilder = new StringBuilder();
    stringBuilder.append("IndexPrice[");
    if (this.security != null) {
      stringBuilder.append("Security[");
      stringBuilder.append("Name=");
      stringBuilder.append(this.security.getName());
      stringBuilder.append(", ");
      stringBuilder.append("WKN=");
      stringBuilder.append(this.security.getWKN());
      stringBuilder.append(", ");
      stringBuilder.append("ISIN=");
      stringBuilder.append(this.security.getISIN());
      stringBuilder.append("]");
    }
    stringBuilder.append("Ask=");
    stringBuilder.append(this.getAsk());
    stringBuilder.append(", ");
    stringBuilder.append("Bid=");
    stringBuilder.append(this.getBid());
    stringBuilder.append(", ");
    stringBuilder.append("Issuer=");
    stringBuilder.append(this.getIssuer());
    stringBuilder.append("]");

    return stringBuilder.toString();
  }
}
