/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.module.merge;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.util.CargoException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentMergerByXslt
implements MergeProcessor {
    private List<Document> documents = new ArrayList<Document>();
    private StreamSource xsltSource;
    private Transformer transformer;

    public DocumentMergerByXslt(InputStream stream) {
        this.xsltSource = new StreamSource(stream);
    }

    public void addMergeItem(Object mergeItem) throws MergeException {
        if (!(mergeItem instanceof Document)) {
            throw new MergeException("DocumentMerger can only merge Documents");
        }
        this.documents.add((Document)mergeItem);
    }

    public Object performMerge() throws MergeException {
        if (this.documents.isEmpty()) {
            return null;
        }
        Document doc = this.documents.get(0);
        for (int i = 1; i < this.documents.size(); ++i) {
            doc = this.merge(doc, this.documents.get(i));
        }
        return doc;
    }

    private Document merge(Document left, Document right) {
        try {
            Document doc = this.createUnifiedDocument(left, right);
            DOMOutputter outputter = new DOMOutputter();
            org.w3c.dom.Document domDocument = outputter.output(doc);
            DOMSource xmlSource = new DOMSource(domDocument);
            if (this.transformer == null) {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                this.transformer = tFactory.newTransformer(this.xsltSource);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult xmlResult = new StreamResult(baos);
            this.transformer.transform(xmlSource, xmlResult);
            SAXBuilder factory = new SAXBuilder();
            factory.setValidation(false);
            factory.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String thePublicId, String theSystemId) throws SAXException {
                    return new InputSource(new StringReader(""));
                }
            });
            return factory.build(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Exception ex) {
            throw new CargoException("Exception whilst trying to transform documents", ex);
        }
    }

    private Document createUnifiedDocument(Document left, Document right) {
        Document mergedDocument = new Document();
        Element rootElement = new Element("merge");
        Element leftElement = new Element("left");
        Element rightElement = new Element("right");
        rootElement.addContent(leftElement);
        rootElement.addContent(rightElement);
        leftElement.addContent((Element)left.getRootElement().clone());
        rightElement.addContent((Element)right.getRootElement().clone());
        mergedDocument.setRootElement(rootElement);
        return mergedDocument;
    }
}

