/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.generic.spi;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.generic.internal.util.RegistrationKey;
import org.codehaus.cargo.generic.spi.AbstractGenericHintFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntrospectionGenericHintFactory<T>
extends AbstractGenericHintFactory<T> {
    private Map<RegistrationKey, String> rejectedMappings = new HashMap<RegistrationKey, String>();

    protected void registerImplementation(RegistrationKey key, String objectClassName) {
        try {
            Class<?> objectClass = this.getClass().getClassLoader().loadClass(objectClassName);
            this.registerImplementation(key, objectClass);
        }
        catch (Exception e) {
            this.rejectedMappings.put(key, objectClassName);
            this.getLogger().warn("Not registering class [" + objectClassName + "] as there was an error: [" + e.getMessage() + "]", this.getClass().getName());
        }
    }

    @Override
    protected T createImplementation(RegistrationKey key, AbstractGenericHintFactory.GenericParameters parameters, String implementationConceptName) {
        Object object;
        try {
            object = super.createImplementation(key, parameters, implementationConceptName);
        }
        catch (ContainerException e) {
            if (this.rejectedMappings.containsKey(key)) {
                String message = "Failed to create a " + implementationConceptName + " for parameters (" + key.toString(implementationConceptName) + ")." + "The container has not been properly registered for that " + implementationConceptName + " type and that's probably because that " + "container implementation class could not been loaded. Are you sure you " + "have added that container's implementation jar to the classpath?";
                throw new ContainerException(message, e);
            }
            throw e;
        }
        return object;
    }
}

