/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.spi.packager;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.packager.Packager;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDirectoryPackager
extends LoggedObject
implements Packager {
    private String targetDirectory;
    private FileHandler fileHandler = new DefaultFileHandler();

    public AbstractDirectoryPackager(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    @Override
    public void packageContainer(InstalledLocalContainer container) {
        this.getFileHandler().copyDirectory(container.getHome(), this.getTargetDirectory(), this.getDistributionExclusions());
        List<String> configurationExclusions = this.getDefaultConfigurationExclusions();
        configurationExclusions.addAll(this.getConfigurationExclusions());
        this.getFileHandler().copyDirectory(container.getConfiguration().getHome(), this.getTargetDirectory(), configurationExclusions);
    }

    private List<String> getDefaultConfigurationExclusions() {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("**/cargocpc.war");
        return excludes;
    }

    protected abstract List<String> getDistributionExclusions();

    protected abstract List<String> getConfigurationExclusions();
}

