/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.codehaus.cargo.container.ContainerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class User {
    private String name;
    private String password;
    private List<String> roles = new ArrayList<String>();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addRoles(List<String> roles) {
        this.roles.addAll(roles);
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean equals(Object userObject) {
        User user;
        boolean result = false;
        if (userObject != null && userObject instanceof User && (user = (User)userObject).getName().equals(this.getName()) && user.getPassword().equals(this.getPassword())) {
            result = user.getRoles().equals(this.getRoles());
        }
        return result;
    }

    public int hashCode() {
        return (this.getName() + this.getPassword()).hashCode();
    }

    public static List<User> parseUsers(String usersAsString) {
        ArrayList<User> users = new ArrayList<User>();
        StringTokenizer userTokens = new StringTokenizer(usersAsString, "|");
        while (userTokens.hasMoreTokens()) {
            users.add(User.parseUser(userTokens.nextToken()));
        }
        return users;
    }

    protected static User parseUser(String userAsString) {
        User user = new User();
        StringTokenizer fieldTokens = new StringTokenizer(userAsString, ":", true);
        try {
            user.setName(fieldTokens.nextToken());
            if (!":".equals(fieldTokens.nextToken())) {
                throw new ContainerException("Invalid format for [" + userAsString + "]");
            }
            String token = fieldTokens.nextToken();
            if (":".equals(token)) {
                user.setPassword("");
            } else {
                user.setPassword(token);
            }
        }
        catch (NoSuchElementException exception) {
            throw new ContainerException("Invalid format for [" + userAsString + "]");
        }
        try {
            if (user.getPassword().length() > 0 && !":".equals(fieldTokens.nextToken())) {
                throw new ContainerException("Invalid format for [" + userAsString + "]");
            }
            user.addRoles(User.parseRoles(fieldTokens.nextToken()));
        }
        catch (NoSuchElementException exception) {
            // empty catch block
        }
        try {
            fieldTokens.nextToken();
            throw new ContainerException("Invalid format for [" + userAsString + "]");
        }
        catch (NoSuchElementException noSuchElementException) {
            return user;
        }
    }

    protected static List<String> parseRoles(String rolesAsString) {
        ArrayList<String> roles = new ArrayList<String>();
        StringTokenizer roleTokens = new StringTokenizer(rolesAsString, ",");
        while (roleTokens.hasMoreTokens()) {
            String roleToken = roleTokens.nextToken();
            roles.add(roleToken);
        }
        return roles;
    }

    public static Map<String, List<User>> createRoleMap(List<User> users) {
        HashMap<String, List<User>> roles = new HashMap<String, List<User>>();
        for (User user : users) {
            for (String role : user.getRoles()) {
                List usersForRole = roles.containsKey(role) ? (List)roles.get(role) : new ArrayList();
                if (!usersForRole.contains(user)) {
                    usersForRole.add(user);
                }
                roles.put(role, usersForRole);
            }
        }
        return roles;
    }
}

