/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jboss;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.JarFile;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerCapability;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.jboss.internal.JBoss7xContainerCapability;
import org.codehaus.cargo.container.spi.AbstractInstalledLocalContainer;
import org.codehaus.cargo.container.spi.jvm.JvmLauncher;

public class JBoss7xInstalledLocalContainer
extends AbstractInstalledLocalContainer {
    public static final String ID = "jboss7x";
    private static final ContainerCapability CAPABILITY = new JBoss7xContainerCapability();
    protected String version;

    public JBoss7xInstalledLocalContainer(LocalConfiguration configuration) {
        super(configuration);
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return "JBoss " + this.getVersion("7.x");
    }

    public ContainerCapability getCapability() {
        return CAPABILITY;
    }

    protected String getVersion(String defaultVersion) {
        String version = this.version;
        if (version == null) {
            try {
                File[] contents;
                File configAdminDirectory = this.getConfigAdminDirectory();
                if (configAdminDirectory.isDirectory()) {
                    contents = configAdminDirectory.listFiles();
                    if (contents.length != 1) {
                        throw new IllegalStateException("The directory " + configAdminDirectory + " does not contain exactly one file.");
                    }
                } else {
                    throw new IllegalArgumentException(configAdminDirectory + " is not a directory.");
                }
                File configAdminFile = contents[0];
                JarFile jarFile = new JarFile(configAdminFile);
                version = jarFile.getManifest().getMainAttributes().getValue("Bundle-Version");
                if (version == null) {
                    version = defaultVersion;
                    this.getLogger().debug("Couldn't find Bundle-Version in the MANIFEST of " + configAdminFile, this.getClass().getName());
                }
            }
            catch (Exception e) {
                version = defaultVersion;
                this.getLogger().debug("Failed to find JBoss version, base error [" + e.getMessage() + "]", this.getClass().getName());
            }
            this.getLogger().info("Parsed JBoss version = [" + version + "]", this.getClass().getName());
            this.version = version;
        }
        return version;
    }

    protected File getConfigAdminDirectory() {
        return new File(this.getHome(), "bundles/org/jboss/as/osgi/configadmin/main");
    }

    protected void addRuntimeArgs(JvmLauncher java) {
    }

    protected void doStart(JvmLauncher java) throws Exception {
        this.copyExtraClasspathJars();
        this.setProperties(java);
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        String modules = this.getConfiguration().getPropertyValue("cargo.jboss.modules.dir");
        if (!new File(modules).isAbsolute()) {
            modules = this.getFileHandler().append(this.getHome(), modules);
        }
        java.addAppArguments("-mp", modules, "-logmodule", "org.jboss.logmanager", "-jaxpmodule", "javax.xml.jaxp-provider", "org.jboss.as.standalone", "--server-config=" + this.getConfiguration().getPropertyValue("cargo.jboss.configuration") + ".xml");
        String runtimeArgs = this.getConfiguration().getPropertyValue("cargo.runtime.args");
        if (runtimeArgs != null) {
            runtimeArgs = runtimeArgs.replace('\n', ' ');
            runtimeArgs = runtimeArgs.replace('\r', ' ');
            runtimeArgs = runtimeArgs.replace('\t', ' ');
            java.addAppArgumentLine(runtimeArgs);
        }
        java.start();
    }

    protected void doStop(JvmLauncher java) throws Exception {
        String host = this.getConfiguration().getPropertyValue("cargo.hostname");
        String port = this.getConfiguration().getPropertyValue("cargo.jboss.management-native.port");
        java.setJarFile(new File(this.getHome(), "jboss-modules.jar"));
        java.addAppArguments("-mp", this.getHome() + "/modules", "-logmodule", "org.jboss.logmanager", "org.jboss.as.cli", "--connect", "--controller=" + host + ":" + port, "command=:shutdown");
        String username = this.getConfiguration().getPropertyValue("cargo.remote.username");
        if (username != null && username.trim().length() != 0) {
            String password = this.getConfiguration().getPropertyValue("cargo.remote.password");
            java.addAppArguments("--user=" + username, "--password=" + password);
        }
        java.start();
    }

    protected void setProperties(JvmLauncher java) throws MalformedURLException {
        java.setSystemProperty("org.jboss.boot.log.file", this.getConfiguration().getHome() + "/log/boot.log");
        java.setSystemProperty("logging.configuration", new File(this.getConfiguration().getHome() + "/configuration/logging.properties").toURI().toURL().toString());
        java.setSystemProperty("jboss.home.dir", this.getHome());
        java.setSystemProperty("jboss.server.base.dir", this.getConfiguration().getHome());
        Map<String, String> systemProperties = this.getSystemProperties();
        if (!systemProperties.containsKey("jboss.bind.address")) {
            String hostname = this.getConfiguration().getPropertyValue("cargo.hostname");
            if ("localhost".equals(hostname)) {
                hostname = "0.0.0.0";
            }
            java.setSystemProperty("jboss.bind.address", hostname);
        }
    }

    protected void copyExtraClasspathJars() throws IOException {
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add("javax.api");
        dependencies.add("javax.transaction.api");
        TreeSet<String> classpath = new TreeSet<String>();
        if (this.getExtraClasspath() != null && this.getExtraClasspath().length != 0) {
            for (String classpathElement : this.getExtraClasspath()) {
                classpath.add(classpathElement);
            }
        }
        if (this.getSharedClasspath() != null && this.getSharedClasspath().length != 0) {
            for (String classpathElement : this.getSharedClasspath()) {
                classpath.add(classpathElement);
            }
        }
        for (String classpathElement : classpath) {
            String moduleName = this.getFileHandler().getName(classpathElement);
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
            moduleName = moduleName.replace('.', '-');
            String folder = this.getHome() + "/modules/org/codehaus/cargo/classpath/" + moduleName + "/main";
            this.getFileHandler().mkdirs(folder);
            StringBuilder dependenciesXml = new StringBuilder();
            for (String dependency : dependencies) {
                dependenciesXml.append("\n    <module name=\"" + dependency + "\"/>");
            }
            dependencies.add("org.codehaus.cargo.classpath." + moduleName);
            FilterChain filterChain = new FilterChain();
            this.getAntUtils().addTokenToFilterChain(filterChain, "moduleName", moduleName);
            this.getAntUtils().addTokenToFilterChain(filterChain, "dependencies", dependenciesXml.toString());
            this.getFileHandler().copyFile(classpathElement, this.getFileHandler().append(folder, moduleName + ".jar"));
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/jboss-module/jboss-module.xml", this.getFileHandler().append(folder, "module.xml"), this.getFileHandler(), filterChain, "UTF-8");
        }
    }
}

