/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.jaxws.securitypriceservice.AbstractSoapBodyDereferencer;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.w3c.dom.Node;

public abstract class XMLDigitalSignature
implements Traceable {
    private final Node signature;

    public XMLDigitalSignature(Node signature) {
        this.signature = signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(PublicKey publicKey) throws NoSuchProviderException, MarshalException, XMLSignatureException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("boolean", this, "verify(PublicKey publicKey)");
        try {
            boolean validated;
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", "XMLDSig");
            DOMValidateContext domValidateContext = new DOMValidateContext(publicKey, this.signature);
            domValidateContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
            domValidateContext.setURIDereferencer(this.getSoapBodyDereferencer());
            XMLSignature xmlSignature = xmlSignatureFactory.unmarshalXMLSignature(domValidateContext);
            boolean bl = validated = xmlSignature.validate(domValidateContext);
            return bl;
        }
        finally {
            tracer.wayout();
        }
    }

    public abstract AbstractSoapBodyDereferencer getSoapBodyDereferencer();
}

