/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.jaxws.securitypriceservice.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapBodyDereferencer
implements URIDereferencer,
Traceable {
    private final XMLSerializer xmlSerializer = new XMLSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Data", this, "dereference(URIReference uriReference, XMLCryptoContext context)");
        try {
            if (!(uriReference instanceof DOMURIReference)) {
                throw new IllegalArgumentException("Need a DOMURIReference.");
            }
            DOMURIReference domURIReference = (DOMURIReference)uriReference;
            Element documentElement = domURIReference.getHere().getOwnerDocument().getDocumentElement();
            NodeList elements = documentElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (elements.getLength() != 1) {
                throw new URIReferenceException("Need a Soap body.");
            }
            Node soapBody = elements.item(0);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.xmlSerializer.serialize(soapBody, outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            OctetStreamData octetStreamData = new OctetStreamData(inputStream);
            return octetStreamData;
        }
        finally {
            tracer.wayout();
        }
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }
}

