/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.jaxws.securitypriceservice.SoapBodyDereferencer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureHandler
implements SOAPHandler<SOAPMessageContext>,
Traceable {
    public static final String STORE_PASS = "changeit";
    public static final String KEY_PASS = "changeit";
    public static final String KEYSTORE_PATH = ".." + File.separator + "mykeystore.jks";
    private final KeyStore keyStore = KeyStore.getInstance("JKS");

    public SignatureHandler() throws GeneralSecurityException, IOException {
        try (FileInputStream inputStream = new FileInputStream(KEYSTORE_PATH);){
            this.keyStore.load(inputStream, "changeit".toCharArray());
        }
    }

    public SignatureHandler(File keystoreFile) throws GeneralSecurityException, IOException {
        try (FileInputStream inputStream = new FileInputStream(keystoreFile);){
            this.keyStore.load(inputStream, "changeit".toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore.PrivateKeyEntry retrieveKey(String alias) throws GeneralSecurityException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("KeyStore.PrivateKeyEntry", this, "retrieveKey(File keyStoreFile)");
        try {
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection("changeit".toCharArray());
            KeyStore.Entry keyEntry = this.keyStore.getEntry(alias, passwordProtection);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyEntry;
            return privateKeyEntry;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(SOAPMessageContext soapMessageContext) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("boolean", this, "handleMessage(SOAPMessageContext messageContext)");
        try {
            tracer.out().printfIndentln("%s = %b", "javax.xml.ws.handler.message.outbound", soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound"));
            boolean outbound = (Boolean)soapMessageContext.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outbound) {
                SOAPMessage soapMessage = soapMessageContext.getMessage();
                try {
                    SOAPHeader soapHeader = soapMessage.getSOAPHeader();
                    SOAPBody soapBody = soapMessage.getSOAPBody();
                    String userId = soapBody.getElementsByTagNameNS("http://de.christofreichardt/SecurityPriceService", "UserId").item(0).getTextContent();
                    this.addSignature((Element)soapHeader, userId);
                }
                catch (GeneralSecurityException | MarshalException | XMLSignatureException | SOAPException ex) {
                    tracer.logException(LogLevel.ERROR, ex, this.getClass(), "handleMessage(SOAPMessageContext soapMessageContext)");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceReferences(List<?> references) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, "traceReferences(List<?> references)");
        try {
            try {
                for (Reference reference : references) {
                    InputStream inputStream = reference.getDigestInputStream();
                    Throwable throwable = null;
                    try {
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                        Throwable throwable2 = null;
                        try {
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            Throwable throwable3 = null;
                            try {
                                String line;
                                while ((line = bufferedReader.readLine()) != null) {
                                    tracer.out().printfIndentln("%s", line);
                                }
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (bufferedReader == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                bufferedReader.close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (inputStreamReader == null) continue;
                            if (throwable2 != null) {
                                try {
                                    inputStreamReader.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            inputStreamReader.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
            }
            catch (IOException ex) {
                tracer.logException(LogLevel.ERROR, ex, this.getClass(), "traceReference(List<?> references)");
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSignature(Element soapHeader, String userId) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, GeneralSecurityException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, "addSignature(Element soapHeader, String userId)");
        try {
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance();
            DigestMethod digestMethod = xmlSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
            Reference reference = xmlSignatureFactory.newReference("#xpointer(/S:Envelope/S:Body)", digestMethod);
            CanonicalizationMethod canonicalizationMethod = xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
            SignatureMethod signatureMethod = xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
            SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(reference));
            XMLSignature xmlSignature = xmlSignatureFactory.newXMLSignature(signedInfo, null);
            DOMSignContext domSignContext = new DOMSignContext(this.retrieveKey(userId).getPrivateKey(), (Node)soapHeader);
            domSignContext.setURIDereferencer(new SoapBodyDereferencer());
            domSignContext.setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
            xmlSignature.sign(domSignContext);
            List<Reference> references = xmlSignature.getSignedInfo().getReferences();
            this.traceReferences(references);
        }
        finally {
            tracer.wayout();
        }
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext context) {
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }
}

