/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import java.io.OutputStream;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public abstract class AbstractXMLSerializer
implements Traceable {
    private final DOMImplementationRegistry domImplRegistry = this.createDOMImplRegistry();
    private final LSOutput lsOutput;
    private final LSSerializer serializer;

    protected AbstractXMLSerializer() {
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)this.domImplRegistry.getDOMImplementation("LS"));
        if (domImplLS == null) {
            throw new RuntimeException("No Load and Save DOM implementation found.");
        }
        this.lsOutput = domImplLS.createLSOutput();
        this.serializer = domImplLS.createLSSerializer();
    }

    private DOMImplementationRegistry createDOMImplRegistry() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("DOMImplementationRegistry", this, "createDOMImplRegistry()");
        try {
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            return dOMImplementationRegistry;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | DOMException ex) {
            tracer.logException(LogLevel.ERROR, ex, this.getClass(), "createDOMImplRegistry()");
            throw new RuntimeException("Cannot create DOMImplRegistry.");
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Node node, OutputStream outputStream) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, "serialize(Node node, OutputStream outputStream)");
        try {
            this.lsOutput.setByteStream(outputStream);
            this.serializer.write(node, this.lsOutput);
        }
        finally {
            tracer.wayout();
        }
    }
}

