/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.jaxws.securitypriceservice;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.jaxws.securitypriceservice.AbstractXMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSoapBodyDereferencer
implements URIDereferencer,
Traceable {
    public static final String SOAPBODY_URI = "#xpointer(/S:Envelope/S:Body)";

    @Override
    public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("Data", this, "dereference(URIReference uriReference, XMLCryptoContext context)");
        try {
            if (SOAPBODY_URI.equals(uriReference.getURI())) {
                if (!(uriReference instanceof DOMURIReference)) {
                    throw new IllegalArgumentException("Need a DOMURIReference.");
                }
                DOMURIReference domURIReference = (DOMURIReference)uriReference;
                Node here = domURIReference.getHere();
                Element documentElement = here.getOwnerDocument().getDocumentElement();
                NodeList elements = documentElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                if (elements.getLength() == 0) {
                    throw new URIReferenceException("No SOAP body found.");
                }
                if (elements.getLength() > 1) {
                    throw new URIReferenceException("Multiple SOAP bodies found.");
                }
                Element soapBodyElement = (Element)elements.item(0);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.getXmlSerializer().serialize(soapBodyElement, outputStream);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                OctetStreamData octetStreamData = new OctetStreamData(inputStream);
                return octetStreamData;
            }
            throw new URIReferenceException("'#xpointer(/S:Envelope/S:Body)' as URI expected.");
        }
        finally {
            tracer.wayout();
        }
    }

    abstract AbstractXMLSerializer getXmlSerializer();
}

