/*
 * Decompiled with CFR 0.152.
 */
package com.werken.saxpath;

import com.werken.saxpath.Token;
import com.werken.saxpath.XPathLexer;
import junit.framework.Assert;
import junit.framework.TestCase;

public class XPathLexerTest
extends TestCase {
    private XPathLexer lexer;
    private Token token;

    public XPathLexerTest(String name) {
        super(name);
    }

    private XPathLexer getLexer() {
        return this.lexer;
    }

    private Token getToken() {
        return this.token;
    }

    private void nextToken() {
        this.setToken(this.getLexer().nextToken());
    }

    private void setLexer(XPathLexer lexer) {
        this.lexer = lexer;
    }

    private void setText(String text) {
        this.lexer = new XPathLexer(text);
    }

    private void setToken(Token token) {
        this.token = token;
    }

    public void setUp() {
    }

    public void tearDown() {
        this.setLexer(null);
        this.setToken(null);
    }

    public void testDouble() {
        this.setText("12.34");
        this.nextToken();
        Assert.assertEquals(31, this.tokenType());
        Assert.assertEquals((Object)"12.34", (Object)this.tokenText());
    }

    public void testDoubleOnlyDecimal() {
        this.setText(".34");
        this.nextToken();
        Assert.assertEquals(31, this.tokenType());
        Assert.assertEquals((Object)".34", (Object)this.tokenText());
    }

    public void testDoubleSlash() {
        this.setText("//");
        this.nextToken();
        Assert.assertEquals(12, this.tokenType());
    }

    public void testEOF() {
        this.setText("foo");
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"foo", (Object)this.tokenText());
        this.nextToken();
        Assert.assertEquals(-1, this.tokenType());
    }

    public void testIdentifier() {
        this.setText("foo");
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"foo", (Object)this.tokenText());
        this.setText("foo.bar");
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"foo.bar", (Object)this.tokenText());
    }

    public void testIdentifierAndOperator() {
        this.setText("foo and bar");
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"foo", (Object)this.tokenText());
        this.nextToken();
        Assert.assertEquals(28, this.tokenType());
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"bar", (Object)this.tokenText());
    }

    public void testIdentifierWithColon() {
        this.setText("foo:bar");
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"foo", (Object)this.tokenText());
        this.nextToken();
        Assert.assertEquals(18, this.tokenType());
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"bar", (Object)this.tokenText());
    }

    public void testInteger() {
        this.setText("1234");
        this.nextToken();
        Assert.assertEquals(30, this.tokenType());
        Assert.assertEquals((Object)"1234", (Object)this.tokenText());
    }

    public void testNamespace() {
        this.setText("a:b");
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"a", (Object)this.tokenText());
        this.nextToken();
        Assert.assertEquals(18, this.tokenType());
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"b", (Object)this.tokenText());
    }

    public void testNumbersAndMode() {
        this.setText("12.34 mod 3");
        this.nextToken();
        Assert.assertEquals(31, this.tokenType());
        Assert.assertEquals((Object)"12.34", (Object)this.tokenText());
        this.nextToken();
        Assert.assertEquals(25, this.tokenType());
        this.nextToken();
        Assert.assertEquals(30, this.tokenType());
    }

    public void testSlash() {
        this.setText("/");
        this.nextToken();
        Assert.assertEquals(11, this.tokenType());
    }

    public void testTrickyIdentifierAndOperator() {
        this.setText("and and and");
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"and", (Object)this.tokenText());
        this.nextToken();
        Assert.assertEquals(28, this.tokenType());
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"and", (Object)this.tokenText());
    }

    public void testWhitespace() {
        this.setText(" /   \tfoo:bar");
        this.nextToken();
        Assert.assertEquals(11, this.tokenType());
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"foo", (Object)this.tokenText());
        this.nextToken();
        Assert.assertEquals(18, this.tokenType());
        this.nextToken();
        Assert.assertEquals(15, this.tokenType());
        Assert.assertEquals((Object)"bar", (Object)this.tokenText());
    }

    private String tokenText() {
        return this.getToken().getTokenText();
    }

    private int tokenType() {
        return this.getToken().getTokenType();
    }
}

