/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package de.christofreichardt.httpmonitor;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 *
 * @author Christof Reichardt
 */
public class RequestParameter implements Traceable {
  final private String requestMethod;
  final private URI requestURI;
  final private String rawPath;
  final private String rawQuery;
  final private Headers requestHeaders;
  
  public RequestParameter(HttpExchange httpExchange) {
    this.requestMethod = httpExchange.getRequestMethod();
    this.requestURI = httpExchange.getRequestURI();
    this.rawPath = this.requestURI.getRawPath();
    this.rawQuery = this.requestURI.getRawQuery();
    this.requestHeaders = httpExchange.getRequestHeaders();
  }

  /**
   * @return the requestMethod
   */
  public String getRequestMethod() {
    return requestMethod;
  }

  /**
   * @return the requestURI
   */
  public URI getRequestURI() {
    return requestURI;
  }

  /**
   * @return the rawPath
   */
  public String getRawPath() {
    return rawPath;
  }

  /**
   * @return the rawQuery
   */
  public String getRawQuery() {
    return rawQuery;
  }

  /**
   * @return the requestHeaders
   */
  public Headers getRequestHeaders() {
    return requestHeaders;
  }
  
  void trace() {
    AbstractTracer tracer = getCurrentTracer();
    tracer.entry("void", this, " trace()");
    
    try {
      tracer.out().printfIndentln("requestMethod = %s", this.requestMethod);
      tracer.out().printfIndentln("requestURI = %s", this.requestURI);
      tracer.out().printfIndentln("rawPath = %s", this.rawPath);
      tracer.out().printfIndentln("rawQuery = %s", this.rawQuery);
      
//      for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
//        tracer.out().printIndent(entry.getKey() + ": ");
//        List<String> values = entry.getValue();
//        Iterator<String> iter = values.iterator();
//        while (iter.hasNext()) {
//          String value = iter.next();
//          tracer.out().print(value);
//          if (iter.hasNext())
//            tracer.out().print(", ");
//        }
//        tracer.out().println();
//      }
    }
    finally {
      tracer.wayout();
    }
  }

  @Override
  public AbstractTracer getCurrentTracer() {
    return TracerFactory.getInstance().getCurrentPoolTracer();
  }
}
