/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.httpmonitor;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.net.URI;

public class RequestParameter
implements Traceable {
    private final String requestMethod;
    private final URI requestURI;
    private final String rawPath;
    private final String rawQuery;
    private final Headers requestHeaders;

    public RequestParameter(HttpExchange httpExchange) {
        this.requestMethod = httpExchange.getRequestMethod();
        this.requestURI = httpExchange.getRequestURI();
        this.rawPath = this.requestURI.getRawPath();
        this.rawQuery = this.requestURI.getRawQuery();
        this.requestHeaders = httpExchange.getRequestHeaders();
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getRawQuery() {
        return this.rawQuery;
    }

    public Headers getRequestHeaders() {
        return this.requestHeaders;
    }

    void trace() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, " trace()");
        try {
            tracer.out().printfIndentln("requestMethod = %s", this.requestMethod);
            tracer.out().printfIndentln("requestURI = %s", this.requestURI);
            tracer.out().printfIndentln("rawPath = %s", this.rawPath);
            tracer.out().printfIndentln("rawQuery = %s", this.rawQuery);
        }
        finally {
            tracer.wayout();
        }
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }
}

