/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.httpmonitor;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.httpmonitor.RequestParameter;
import de.christofreichardt.httpmonitor.SOAPTracer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class HttpRelais
implements HttpHandler,
Traceable {
    private final String serverHost;
    private final int serverPortNo;
    private final SOAPTracer soapTracer;

    public HttpRelais(String serverHost, int serverPortNo) {
        this.serverHost = serverHost;
        this.serverPortNo = serverPortNo;
        this.soapTracer = new SOAPTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.initCurrentTracingContext();
        tracer.entry("void", (Object)this, "handle(HttpExchange httpExchange)");
        try {
            RequestParameter requestParameter = new RequestParameter(httpExchange);
            requestParameter.trace();
            try {
                URL url = this.constructUrl(requestParameter);
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod(requestParameter.getRequestMethod());
                this.forwardRequestHeaders(requestParameter.getRequestHeaders(), urlConnection);
                if (requestParameter.getRequestMethod().equalsIgnoreCase("POST")) {
                    urlConnection.setDoOutput(true);
                    this.forwardRequestBody(httpExchange, urlConnection);
                    int responseCode = urlConnection.getResponseCode();
                    tracer.out().printfIndentln("responseCode = %d", new Object[]{responseCode});
                    this.forwardResponseHeader(urlConnection, httpExchange, responseCode);
                    this.forwardResponseBody(urlConnection, httpExchange, responseCode);
                } else if (requestParameter.getRequestMethod().equalsIgnoreCase("GET")) {
                    int responseCode = urlConnection.getResponseCode();
                    tracer.out().printfIndentln("responseCode = %d", new Object[]{responseCode});
                    this.forwardResponseHeader(urlConnection, httpExchange, responseCode);
                    this.forwardResponseBody(urlConnection, httpExchange, responseCode);
                }
            }
            catch (IOException ex) {
                tracer.logException(LogLevel.ERROR, (Throwable)ex, this.getClass(), "handle(HttpExchange httpExchange)");
            }
            catch (Throwable t) {
                tracer.logException(LogLevel.ERROR, t, this.getClass(), "handle(HttpExchange httpExchange)");
                httpExchange.close();
            }
            finally {
                httpExchange.close();
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL constructUrl(RequestParameter requestParameter) throws MalformedURLException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("String", (Object)this, "constructUrl(RequestParameter requestParameter)");
        try {
            String spec = requestParameter.getRawPath() != null ? "http://" + this.serverHost + ":" + this.serverPortNo + requestParameter.getRawPath() : "http://" + this.serverHost + ":" + this.serverPortNo;
            if (requestParameter.getRawQuery() != null) {
                spec = spec + "?" + requestParameter.getRawQuery();
            }
            tracer.out().printfIndentln("spec = %s", new Object[]{spec});
            URL uRL = new URL(spec);
            return uRL;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardRequestHeaders(Headers requestHeaders, HttpURLConnection urlConnection) {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "forwardRequestHeaders(Headers requestHeaders, HttpURLConnection urlConnection)");
        try {
            for (Map.Entry<String, List<String>> entry : requestHeaders.entrySet()) {
                if ("Host".equals(entry.getKey())) continue;
                tracer.out().printIndent(entry.getKey() + ": ");
                StringBuilder stringBuilder = new StringBuilder();
                List<String> values = entry.getValue();
                Iterator<String> iter = values.iterator();
                while (iter.hasNext()) {
                    String value = iter.next();
                    tracer.out().print(value);
                    stringBuilder.append(value);
                    if (!iter.hasNext()) continue;
                    tracer.out().print(", ");
                    stringBuilder.append(", ");
                }
                tracer.out().println();
                urlConnection.setRequestProperty(entry.getKey(), stringBuilder.toString());
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardRequestBody(HttpExchange httpExchange, HttpURLConnection urlConnection) throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "forwardRequestBody(HttpExchange httpExchange, HttpURLConnection urlConnection)");
        try {
            int BUFFER_SIZE = 256;
            byte[] buffer = new byte[256];
            try (InputStream inputStream = httpExchange.getRequestBody();
                 ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                while (true) {
                    int read = inputStream.read(buffer);
                    tracer.out().printfIndentln("read = %d", new Object[]{read});
                    tracer.out().flush();
                    if (read == -1) break;
                    byteArrayOutputStream.write(buffer, 0, read);
                }
                byte[] bytes = byteArrayOutputStream.toByteArray();
                Document document = this.soapTracer.parse(bytes);
                this.soapTracer.trace(document);
                try (OutputStream outputStream = urlConnection.getOutputStream();){
                    outputStream.write(bytes);
                }
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardResponseHeader(HttpURLConnection urlConnection, HttpExchange httpExchange, int responseCode) throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "forwardResponseHeader(HttpURLConnection urlConnection, HttpExchange httpExchange, int responseCode)");
        try {
            Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
            Headers responseHeaders = httpExchange.getResponseHeaders();
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                if (entry.getKey() == null) continue;
                tracer.out().printIndent(entry.getKey() + ": ");
                responseHeaders.put(entry.getKey(), entry.getValue());
                List<String> values = entry.getValue();
                Iterator<String> iter = values.iterator();
                while (iter.hasNext()) {
                    String value = iter.next();
                    tracer.out().print(value);
                    if (!iter.hasNext()) continue;
                    tracer.out().print(", ");
                }
                tracer.out().println();
            }
            httpExchange.sendResponseHeaders(responseCode, 0L);
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardResponseBody(HttpURLConnection urlConnection, HttpExchange httpExchange, int responseCode) throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "forwardResponseBody(HttpURLConnection urlConnection, HttpExchange httpExchange)");
        try {
            int BUFFER_SIZE = 256;
            byte[] buffer = new byte[256];
            try (InputStream inputStream = this.getInputStreamForResponse(urlConnection, responseCode);
                 ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                while (true) {
                    int read = inputStream.read(buffer);
                    tracer.out().printfIndentln("read = %d", new Object[]{read});
                    tracer.out().flush();
                    if (read == -1) break;
                    byteArrayOutputStream.write(buffer, 0, read);
                }
                byte[] bytes = byteArrayOutputStream.toByteArray();
                Document document = this.soapTracer.parse(bytes);
                this.soapTracer.trace(document);
                try (OutputStream outputStream = httpExchange.getResponseBody();){
                    outputStream.write(bytes);
                }
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStreamForResponse(HttpURLConnection urlConnection, int responseCode) throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", (Object)this, "forwardResponseBody(HttpURLConnection urlConnection, HttpExchange httpExchange)");
        try {
            InputStream inputStream = responseCode != 200 ? urlConnection.getErrorStream() : urlConnection.getInputStream();
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            tracer.wayout();
        }
    }

    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }
}

