/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.christofreichardt.httpmonitor;

import de.christofreichardt.diagnosis.TracerFactory;
import java.io.InputStream;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

/**
 *
 * @author Developer
 */
@RunWith(Suite.class)
@Suite.SuiteClasses({
  HttpUnit.class
})
public class MyTestSuite {
  
  @BeforeClass
  public static void init() throws TracerFactory.Exception {
    TracerFactory.getInstance().reset();
    InputStream resourceAsStream = MyTestSuite.class.getClassLoader().getResourceAsStream("de/christofreichardt/httpmonitor/trace-config.xml");
    if (resourceAsStream != null) {
      TracerFactory.getInstance().readConfiguration(resourceAsStream);
    }
    TracerFactory.getInstance().openPoolTracer();
    TracerFactory.getInstance().getCurrentPoolTracer().initCurrentTracingContext();
  }
  
  @AfterClass
  public static void exit() {
    TracerFactory.getInstance().closePoolTracer();
    System.out.println();
  }
}
