/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package de.christofreichardt.httpmonitor;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;

/**
 *
 * @author Christof Reichardt
 */
public class HttpGetTask implements Callable<Integer>, Traceable {

  @Override
  public Integer call() throws Exception {
    AbstractTracer tracer = getCurrentTracer();
    tracer.initCurrentTracingContext();
    tracer.entry("Integer", this, "call()");
    
    try {
      URL url = new URL("http://localhost:7070/r/programming/");
      HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
      urlConnection.setRequestProperty("Accept-Charset", HttpUnit.CHARSET);
      urlConnection.connect();
      int responseCode = urlConnection.getResponseCode();
      String statusline = String.format("HTTP/1.0 %d %s", responseCode, urlConnection.getResponseMessage());

      tracer.out().printfIndentln("statusline = %s", statusline);

      try (InputStream inputStream = urlConnection.getInputStream()) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName(HttpUnit.CHARSET));
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        do {
          String line = lineNumberReader.readLine();
          if (line == null) {
            break;
          }

          tracer.out().printfIndentln("line = %s", line);
        } while (true);
      }
      
      return responseCode;
    }
    finally {
      tracer.wayout();
    }
  }

  @Override
  public AbstractTracer getCurrentTracer() {
    return TracerFactory.getInstance().getCurrentPoolTracer();
  }

}
