/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.httpmonitor;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.Traceable;
import de.christofreichardt.diagnosis.TracerFactory;
import de.christofreichardt.httpmonitor.HttpRelais;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class App
implements Traceable {
    private final HttpServer httpServer;
    private final ExecutorService executorService;
    private final String contextPath;
    private final HttpRelais httpRelais;

    public App() throws IOException {
        Properties properties = this.init();
        if (!properties.containsKey("de.christofreichardt.httpmonitor.serverHost")) {
            throw new RuntimeException("Missing 'de.christofreichardt.httpmonitor.serverHost' property.");
        }
        String serverHost = properties.getProperty("de.christofreichardt.httpmonitor.serverHost");
        int serverPortNo = Integer.parseInt(properties.getProperty("de.christofreichardt.httpmonitor.serverPortNo", "8080"));
        this.httpRelais = new HttpRelais(serverHost, serverPortNo);
        if (!properties.containsKey("de.christofreichardt.httpmonitor.clientPortNo")) {
            throw new RuntimeException("Missing 'de.christofreichardt.httpmonitor.clientPortNo' property.");
        }
        int clientPortNo = Integer.parseInt(properties.getProperty("de.christofreichardt.httpmonitor.clientPortNo"));
        this.httpServer = HttpServer.create(new InetSocketAddress(clientPortNo), 0);
        int nThreads = Integer.parseInt(properties.getProperty("de.christofreichardt.httpmonitor.nThreads", "3"));
        this.executorService = Executors.newFixedThreadPool(nThreads, new ThreadFactory(){
            private final AtomicInteger threadCounter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Worker-" + this.threadCounter.getAndIncrement());
            }
        });
        if (!properties.containsKey("de.christofreichardt.httpmonitor.contextPath")) {
            throw new RuntimeException("Missing 'de.christofreichardt.httpmonitor.contextPath' property.");
        }
        this.contextPath = properties.getProperty("de.christofreichardt.httpmonitor.contextPath");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties init() throws IOException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, "init()");
        try {
            Properties properties = new Properties();
            File propertiesFile = new File("." + File.separator + "httpmonitor.properties");
            try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
                properties.load(fileInputStream);
            }
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exit() {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, "exit()");
        try {
            long TIMEOUT = 5L;
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        tracer.logMessage(LogLevel.WARNING, "Thread pool didn't terminate.", this.getClass(), "exit()");
                    }
                }
            }
            catch (InterruptedException ex) {
                tracer.logException(LogLevel.WARNING, ex, this.getClass(), "exit()");
            }
        }
        finally {
            tracer.wayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor() throws IOException, InterruptedException {
        AbstractTracer tracer = this.getCurrentTracer();
        tracer.entry("void", this, "monitor()");
        try {
            this.httpServer.setExecutor(this.executorService);
            HttpContext httpContext = this.httpServer.createContext(this.contextPath);
            httpContext.setHandler(this.httpRelais);
            this.httpServer.start();
            tracer.out().printfIndentln("Server has been started.", new Object[0]);
            tracer.out().flush();
            File stopFile = new File("." + File.separator + "stop.txt");
            stopFile.createNewFile();
            long lastModified = stopFile.lastModified();
            long INTERVAL = 2500L;
            do {
                Thread.sleep(INTERVAL);
                System.out.printf("Monitoring ...%n", new Object[0]);
            } while (stopFile.lastModified() <= lastModified);
            int DELAY = 5;
            this.httpServer.stop(DELAY);
        }
        finally {
            tracer.wayout();
        }
    }

    @Override
    public AbstractTracer getCurrentTracer() {
        return TracerFactory.getInstance().getCurrentPoolTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws TracerFactory.Exception {
        TracerFactory.getInstance().reset();
        InputStream resourceAsStream = App.class.getClassLoader().getResourceAsStream("de/christofreichardt/httpmonitor/trace-config.xml");
        if (resourceAsStream != null) {
            TracerFactory.getInstance().readConfiguration(resourceAsStream);
        }
        TracerFactory.getInstance().openPoolTracer();
        try {
            AbstractTracer tracer = TracerFactory.getInstance().getCurrentPoolTracer();
            tracer.initCurrentTracingContext();
            tracer.entry("void", App.class, "main(String[] args)");
            try {
                ArrayList<String> propertyNames = new ArrayList<String>(System.getProperties().stringPropertyNames());
                Collections.sort(propertyNames);
                for (String propertyName : propertyNames) {
                    tracer.out().printfIndentln("%s = %s", propertyName, System.getProperties().getProperty(propertyName));
                }
                try {
                    App app = new App();
                    try {
                        app.monitor();
                    }
                    finally {
                        app.exit();
                    }
                }
                catch (Exception ex) {
                    tracer.logException(LogLevel.ERROR, ex, App.class, "main(String[] args)");
                }
            }
            finally {
                tracer.wayout();
            }
        }
        finally {
            TracerFactory.getInstance().closePoolTracer();
        }
    }
}

