/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis.file;

import de.christofreichardt.diagnosis.DebugLogTee;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.TraceMethod;
import de.christofreichardt.diagnosis.file.FileTracerLogTee;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class FileTracerLog4jTee
extends FileTracerLogTee {
    public FileTracerLog4jTee(String name) {
        super(name);
    }

    protected Level convertToLog4jLevel(LogLevel logLevel) {
        Level level = Level.OFF;
        switch (logLevel) {
            case INFO: {
                level = Level.INFO;
                break;
            }
            case WARNING: {
                level = Level.WARN;
                break;
            }
            case ERROR: {
                level = Level.ERROR;
                break;
            }
            case FATAL: 
            case SEVERE: {
                level = Level.FATAL;
                break;
            }
        }
        return level;
    }

    @Override
    protected void adapt(LogLevel logLevel, String message, Class clazz) {
        Logger logger = Logger.getLogger((Class)clazz);
        Level level = this.convertToLog4jLevel(logLevel);
        logger.log(DebugLogTee.class.getName(), (Priority)level, (Object)message, null);
    }

    @Override
    protected void adapt(LogLevel logLevel, Throwable throwable, Class clazz) {
        Logger logger = Logger.getLogger((Class)clazz);
        Level level = this.convertToLog4jLevel(logLevel);
        logger.log(DebugLogTee.class.getName(), (Priority)level, (Object)throwable.getMessage(), throwable);
    }

    @Override
    @Deprecated
    public TraceMethod entry(String methodSignature) {
        TraceMethod traceMethod = super.entry(methodSignature);
        if (traceMethod != null) {
            String className = "STATIC";
            Logger logger = Logger.getLogger((String)className);
            logger.log(this.getClass().getName(), (Priority)Level.DEBUG, (Object)("ENTRY--" + methodSignature), null);
        }
        return traceMethod;
    }

    @Override
    public TraceMethod entry(String returnType, Object object, String methodSignature) {
        TraceMethod traceMethod = super.entry(returnType, object, methodSignature);
        if (traceMethod != null) {
            String className = object != null ? object.getClass().getName() : "STATIC";
            Logger logger = Logger.getLogger((String)className);
            logger.log(this.getClass().getName(), (Priority)Level.DEBUG, (Object)("ENTRY--" + methodSignature), null);
        }
        return traceMethod;
    }

    @Override
    public TraceMethod entry(String returnType, Class clazz, String methodSignature) {
        TraceMethod traceMethod = super.entry(returnType, clazz, methodSignature);
        if (traceMethod != null) {
            String className = clazz != null ? clazz.getName() : "STATIC";
            Logger logger = Logger.getLogger((String)className);
            logger.log(this.getClass().getName(), (Priority)Level.DEBUG, (Object)("ENTRY--" + methodSignature), null);
        }
        return traceMethod;
    }

    @Override
    public TraceMethod wayout() {
        TraceMethod traceMethod = super.wayout();
        if (traceMethod != null) {
            Logger logger = traceMethod.getClazz() != null ? Logger.getLogger((String)traceMethod.getClazz().getName()) : Logger.getLogger((String)"STATIC");
            logger.log(this.getClass().getName(), (Priority)Level.DEBUG, (Object)("RETURN-" + traceMethod.getMethodName()), null);
        }
        return traceMethod;
    }
}

