/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis;

import java.lang.management.ManagementFactory;

public class TraceMethod {
    private final String signature;
    private final Class<?> clazz;
    private final long startTime = System.currentTimeMillis();
    private final long startCpuTime = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
    private long elapsedTime;
    private long elapsedCpuTime;
    private final String methodName;

    public TraceMethod(String signature) {
        this.signature = signature;
        this.methodName = signature;
        this.clazz = null;
    }

    @Deprecated
    public TraceMethod(String signature, Class<?> clazz) {
        this.signature = signature;
        this.methodName = signature;
        this.clazz = clazz;
    }

    public TraceMethod(String returnType, Object object, String methodSignature) {
        this.clazz = object.getClass();
        this.signature = returnType + " " + this.clazz.getSimpleName() + "[" + System.identityHashCode(object) + "]." + methodSignature;
        this.methodName = methodSignature;
    }

    public TraceMethod(String returnType, Class clazz, String methodSignature) {
        this.clazz = clazz;
        this.signature = returnType + " " + this.clazz.getSimpleName() + "." + methodSignature;
        this.methodName = methodSignature;
    }

    public String getSignature() {
        return this.signature;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getElapsedCpuTime() {
        return this.elapsedCpuTime;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void stopTime() {
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        this.elapsedCpuTime = (ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() - this.startCpuTime) / 1000000L;
    }
}

